/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.javabean.session.impl;

import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import org.hibernate.search.mapper.javabean.mapping.context.impl.JavaBeanMappingContext;
import org.hibernate.search.mapper.javabean.search.JavaBeanSearchTarget;
import org.hibernate.search.mapper.javabean.search.impl.JavaBeanSearchTargetImpl;
import org.hibernate.search.mapper.javabean.session.JavaBeanSearchManager;
import org.hibernate.search.mapper.javabean.session.JavaBeanSearchManagerBuilder;
import org.hibernate.search.mapper.javabean.session.context.impl.JavaBeanSessionContext;
import org.hibernate.search.mapper.javabean.work.JavaBeanWorkPlan;
import org.hibernate.search.mapper.javabean.work.impl.JavaBeanWorkPlanImpl;
import org.hibernate.search.mapper.pojo.mapping.spi.PojoMappingDelegate;
import org.hibernate.search.mapper.pojo.model.spi.PojoRuntimeIntrospector;
import org.hibernate.search.mapper.pojo.session.context.spi.AbstractPojoSessionContextImplementor;
import org.hibernate.search.mapper.pojo.session.spi.AbstractPojoSearchManager;

public class JavaBeanSearchManagerImpl
extends AbstractPojoSearchManager
implements JavaBeanSearchManager {
    private JavaBeanWorkPlanImpl workPlan;

    private JavaBeanSearchManagerImpl(JavaBeanSearchManagerBuilderImpl builder) {
        super((AbstractPojoSearchManager.AbstractBuilder)builder);
    }

    @Override
    public void close() {
        if (this.workPlan != null) {
            CompletableFuture<?> future = this.workPlan.execute();
            future.join();
        }
    }

    @Override
    public <T> JavaBeanSearchTarget search(Collection<? extends Class<? extends T>> targetedTypes) {
        return new JavaBeanSearchTargetImpl(this.getDelegate().createPojoSearchTarget(targetedTypes));
    }

    @Override
    public JavaBeanWorkPlan getMainWorkPlan() {
        if (this.workPlan == null) {
            this.workPlan = new JavaBeanWorkPlanImpl(this.getDelegate().createWorkPlan());
        }
        return this.workPlan;
    }

    public static class JavaBeanSearchManagerBuilderImpl
    extends AbstractPojoSearchManager.AbstractBuilder<JavaBeanSearchManagerImpl>
    implements JavaBeanSearchManagerBuilder {
        private final JavaBeanMappingContext mappingContext;
        private String tenantId;

        public JavaBeanSearchManagerBuilderImpl(PojoMappingDelegate mappingDelegate, JavaBeanMappingContext mappingContext) {
            super(mappingDelegate);
            this.mappingContext = mappingContext;
        }

        @Override
        public JavaBeanSearchManagerBuilderImpl tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        protected AbstractPojoSessionContextImplementor buildSessionContext() {
            return new JavaBeanSessionContext(this.mappingContext, this.tenantId, PojoRuntimeIntrospector.noProxy());
        }

        @Override
        public JavaBeanSearchManagerImpl build() {
            return new JavaBeanSearchManagerImpl(this);
        }
    }
}

