/*
 * Hibernate Search, full-text search for your domain model
 *
 * License: GNU Lesser General Public License (LGPL), version 2.1 or later
 * See the lgpl.txt file in the root directory or <http://www.gnu.org/licenses/lgpl-2.1.html>.
 */
package org.hibernate.search.mapper.javabean.search.query.impl;

import java.util.List;

import org.hibernate.search.engine.search.query.spi.IndexSearchResult;
import org.hibernate.search.mapper.javabean.search.query.SearchResult;

class JavaBeanSearchResult<T> implements SearchResult<T> {

	private final IndexSearchResult<T> delegate;

	JavaBeanSearchResult(IndexSearchResult<T> delegate) {
		this.delegate = delegate;
	}

	@Override
	public long getTotalHitCount() {
		return delegate.getTotalHitCount();
	}

	@Override
	public List<T> getHits() {
		return delegate.getHits();
	}
}
