/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.javabean;

import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.hibernate.search.engine.cfg.ConfigurationPropertySource;
import org.hibernate.search.engine.common.spi.SearchIntegration;
import org.hibernate.search.engine.common.spi.SearchIntegrationBuilder;
import org.hibernate.search.engine.common.spi.SearchIntegrationPartialBuildState;
import org.hibernate.search.engine.mapper.mapping.building.spi.MappingInitiator;
import org.hibernate.search.engine.mapper.mapping.spi.MappingKey;
import org.hibernate.search.mapper.javabean.CloseableJavaBeanMapping;
import org.hibernate.search.mapper.javabean.JavaBeanMapping;
import org.hibernate.search.mapper.javabean.impl.JavaBeanMappingInitiator;
import org.hibernate.search.mapper.javabean.mapping.impl.JavaBeanMappingImpl;
import org.hibernate.search.mapper.javabean.mapping.impl.JavaBeanMappingKey;
import org.hibernate.search.mapper.javabean.mapping.impl.JavaBeanMappingPartialBuildState;
import org.hibernate.search.mapper.javabean.model.impl.JavaBeanBootstrapIntrospector;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.AnnotationMappingDefinitionContext;
import org.hibernate.search.mapper.pojo.mapping.definition.programmatic.ProgrammaticMappingDefinitionContext;
import org.hibernate.search.util.common.impl.SuppressingCloser;

public final class JavaBeanMappingBuilder {
    private final ConfigurationPropertySource propertySource;
    private final Map<String, Object> overriddenProperties = new HashMap<String, Object>();
    private final SearchIntegrationBuilder integrationBuilder;
    private final JavaBeanMappingKey mappingKey;
    private final JavaBeanMappingInitiator mappingInitiator;

    JavaBeanMappingBuilder(ConfigurationPropertySource basePropertySource, MethodHandles.Lookup lookup) {
        this.propertySource = basePropertySource.withOverride(ConfigurationPropertySource.fromMap(this.overriddenProperties));
        this.integrationBuilder = SearchIntegration.builder((ConfigurationPropertySource)this.propertySource);
        JavaBeanBootstrapIntrospector introspector = new JavaBeanBootstrapIntrospector(lookup);
        this.mappingKey = new JavaBeanMappingKey();
        this.mappingInitiator = new JavaBeanMappingInitiator(introspector);
        this.integrationBuilder.addMappingInitiator((MappingKey)this.mappingKey, (MappingInitiator)this.mappingInitiator);
        this.mappingInitiator.setAnnotatedTypeDiscoveryEnabled(true);
    }

    public ProgrammaticMappingDefinitionContext programmaticMapping() {
        return this.mappingInitiator.programmaticMapping();
    }

    public AnnotationMappingDefinitionContext annotationMapping() {
        return this.mappingInitiator.annotationMapping();
    }

    public JavaBeanMappingBuilder addEntityType(Class<?> type) {
        this.mappingInitiator.addEntityType(type);
        return this;
    }

    public JavaBeanMappingBuilder addEntityTypes(Set<Class<?>> types) {
        for (Class<?> type : types) {
            this.addEntityType(type);
        }
        return this;
    }

    public JavaBeanMappingBuilder setMultiTenancyEnabled(boolean multiTenancyEnabled) {
        this.mappingInitiator.setMultiTenancyEnabled(multiTenancyEnabled);
        return this;
    }

    public JavaBeanMappingBuilder setImplicitProvidedId(boolean multiTenancyEnabled) {
        this.mappingInitiator.setImplicitProvidedId(multiTenancyEnabled);
        return this;
    }

    public JavaBeanMappingBuilder setAnnotatedTypeDiscoveryEnabled(boolean annotatedTypeDiscoveryEnabled) {
        this.mappingInitiator.setAnnotatedTypeDiscoveryEnabled(annotatedTypeDiscoveryEnabled);
        return this;
    }

    public JavaBeanMappingBuilder setProperty(String name, Object value) {
        this.overriddenProperties.put(name, value);
        return this;
    }

    public CloseableJavaBeanMapping build() {
        JavaBeanMapping mapping;
        SearchIntegrationPartialBuildState integrationPartialBuildState = this.integrationBuilder.prepareBuild();
        SearchIntegration integration = null;
        try {
            mapping = (JavaBeanMapping)integrationPartialBuildState.finalizeMapping((MappingKey)this.mappingKey, JavaBeanMappingPartialBuildState::finalizeMapping);
            integration = integrationPartialBuildState.finalizeIntegration(this.propertySource);
        }
        catch (RuntimeException e) {
            new SuppressingCloser((Throwable)e).push(SearchIntegrationPartialBuildState::closeOnFailure, (Object)integrationPartialBuildState);
            throw e;
        }
        try {
            JavaBeanMappingImpl mappingImpl = (JavaBeanMappingImpl)mapping;
            mappingImpl.onClose(() -> ((SearchIntegration)integration).close());
            return mappingImpl;
        }
        catch (RuntimeException e) {
            new SuppressingCloser((Throwable)e).push((AutoCloseable)integration);
            throw e;
        }
    }
}

