/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.javabean.model.impl;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.hibernate.search.engine.mapper.model.spi.MappableTypeModel;
import org.hibernate.search.mapper.javabean.log.impl.Log;
import org.hibernate.search.mapper.javabean.model.impl.JavaBeanBootstrapIntrospector;
import org.hibernate.search.mapper.javabean.model.impl.JavaBeanPropertyModel;
import org.hibernate.search.mapper.pojo.model.spi.GenericContextAwarePojoGenericTypeModel;
import org.hibernate.search.mapper.pojo.model.spi.JavaClassPojoCaster;
import org.hibernate.search.mapper.pojo.model.spi.PojoCaster;
import org.hibernate.search.mapper.pojo.model.spi.PojoPropertyModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.mapper.pojo.util.spi.JavaClassOrdering;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

class JavaBeanTypeModel<T>
implements PojoRawTypeModel<T> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final JavaBeanBootstrapIntrospector introspector;
    private final Class<T> clazz;
    private final BeanInfo beanInfo;
    private final BeanInfo declaredBeanInfo;
    private final GenericContextAwarePojoGenericTypeModel.RawTypeDeclaringContext<T> rawTypeDeclaringContext;
    private final PojoCaster<T> caster;

    JavaBeanTypeModel(JavaBeanBootstrapIntrospector introspector, Class<T> clazz, GenericContextAwarePojoGenericTypeModel.RawTypeDeclaringContext<T> rawTypeDeclaringContext) throws IntrospectionException {
        this.introspector = introspector;
        this.clazz = clazz;
        this.beanInfo = Introspector.getBeanInfo(clazz);
        this.declaredBeanInfo = Introspector.getBeanInfo(clazz, clazz.getSuperclass());
        this.rawTypeDeclaringContext = rawTypeDeclaringContext;
        this.caster = new JavaClassPojoCaster(clazz);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JavaBeanTypeModel that = (JavaBeanTypeModel)o;
        return Objects.equals(this.introspector, that.introspector) && Objects.equals(this.clazz, that.clazz);
    }

    public int hashCode() {
        return Objects.hash(this.introspector, this.clazz);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.clazz.getName() + "]";
    }

    public String getName() {
        return this.clazz.getName();
    }

    public boolean isAbstract() {
        return Modifier.isAbstract(this.clazz.getModifiers());
    }

    public boolean isSubTypeOf(MappableTypeModel other) {
        return other instanceof JavaBeanTypeModel && ((JavaBeanTypeModel)other).clazz.isAssignableFrom(this.clazz);
    }

    public PojoRawTypeModel<? super T> getRawType() {
        return this;
    }

    public boolean isSubTypeOf(Class<?> superClassCandidate) {
        return superClassCandidate.isAssignableFrom(this.clazz);
    }

    public Stream<? extends PojoRawTypeModel<? super T>> getAscendingSuperTypes() {
        return JavaClassOrdering.get().getAscendingSuperTypes(this.clazz).map(clazz -> this.introspector.getTypeModel(clazz));
    }

    public Stream<? extends PojoRawTypeModel<? super T>> getDescendingSuperTypes() {
        return JavaClassOrdering.get().getDescendingSuperTypes(this.clazz).map(clazz -> this.introspector.getTypeModel(clazz));
    }

    public <A extends Annotation> Optional<A> getAnnotationByType(Class<A> annotationType) {
        return this.introspector.getAnnotationByType(this.clazz, annotationType);
    }

    public <A extends Annotation> Stream<A> getAnnotationsByType(Class<A> annotationType) {
        return this.introspector.getAnnotationsByType(this.clazz, annotationType);
    }

    public Stream<? extends Annotation> getAnnotationsByMetaAnnotationType(Class<? extends Annotation> metaAnnotationType) {
        return this.introspector.getAnnotationsByMetaAnnotationType(this.clazz, metaAnnotationType);
    }

    public PojoPropertyModel<?> getProperty(String propertyName) {
        String normalizedName = Introspector.decapitalize(propertyName);
        PropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(normalizedName);
        return this.createProperty(propertyDescriptor);
    }

    public Stream<PojoPropertyModel<?>> getDeclaredProperties() {
        return Arrays.stream(this.declaredBeanInfo.getPropertyDescriptors()).filter(descriptor -> descriptor.getReadMethod() != null).map(this::createProperty);
    }

    public PojoCaster<T> getCaster() {
        return this.caster;
    }

    public Class<T> getJavaClass() {
        return this.clazz;
    }

    GenericContextAwarePojoGenericTypeModel.RawTypeDeclaringContext<T> getRawTypeDeclaringContext() {
        return this.rawTypeDeclaringContext;
    }

    private PropertyDescriptor getPropertyDescriptor(String normalizedName) {
        PropertyDescriptor[] propertyDescriptors;
        for (PropertyDescriptor descriptor : propertyDescriptors = this.beanInfo.getPropertyDescriptors()) {
            if (!normalizedName.equals(descriptor.getName())) continue;
            return descriptor;
        }
        throw log.cannotFindProperty(this, normalizedName);
    }

    private PojoPropertyModel<?> createProperty(PropertyDescriptor propertyDescriptor) {
        if (propertyDescriptor.getReadMethod() == null) {
            throw log.cannotReadProperty(this, propertyDescriptor.getName());
        }
        return new JavaBeanPropertyModel(this.introspector, this, propertyDescriptor);
    }
}

