/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.javabean.model.impl;

import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Type;
import java.util.Objects;
import java.util.stream.Stream;
import org.hibernate.search.mapper.javabean.log.impl.Log;
import org.hibernate.search.mapper.javabean.model.impl.JavaBeanBootstrapIntrospector;
import org.hibernate.search.mapper.javabean.model.impl.JavaBeanTypeModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoGenericTypeModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoPropertyModel;
import org.hibernate.search.mapper.pojo.model.spi.PropertyHandle;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

class JavaBeanPropertyModel<T>
implements PojoPropertyModel<T> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final JavaBeanBootstrapIntrospector introspector;
    private final JavaBeanTypeModel<?> parentTypeModel;
    private final PropertyDescriptor descriptor;
    private PojoGenericTypeModel<T> typeModel;
    private PropertyHandle<T> handle;

    JavaBeanPropertyModel(JavaBeanBootstrapIntrospector introspector, JavaBeanTypeModel<?> parentTypeModel, PropertyDescriptor descriptor) {
        this.introspector = introspector;
        this.parentTypeModel = parentTypeModel;
        this.descriptor = descriptor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JavaBeanPropertyModel that = (JavaBeanPropertyModel)o;
        return Objects.equals(this.introspector, that.introspector) && Objects.equals(this.parentTypeModel, that.parentTypeModel) && Objects.equals(this.getHandle(), that.getHandle());
    }

    public int hashCode() {
        return Objects.hash(this.introspector, this.parentTypeModel, this.handle);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getName() + ", " + this.getGetterGenericReturnType().getTypeName() + "]";
    }

    public String getName() {
        return this.descriptor.getName();
    }

    public <A extends Annotation> Stream<A> getAnnotationsByType(Class<A> annotationType) {
        return this.introspector.getAnnotationsByType(this.descriptor.getReadMethod(), annotationType);
    }

    public Stream<? extends Annotation> getAnnotationsByMetaAnnotationType(Class<? extends Annotation> metaAnnotationType) {
        return this.introspector.getAnnotationsByMetaAnnotationType(this.descriptor.getReadMethod(), metaAnnotationType);
    }

    public PojoGenericTypeModel<T> getTypeModel() {
        if (this.typeModel == null) {
            try {
                this.typeModel = this.parentTypeModel.getRawTypeDeclaringContext().createGenericTypeModel(this.getGetterGenericReturnType());
            }
            catch (RuntimeException e) {
                throw log.errorRetrievingPropertyTypeModel(this.getName(), this.parentTypeModel, e);
            }
        }
        return this.typeModel;
    }

    public PropertyHandle<T> getHandle() {
        if (this.handle == null) {
            try {
                this.handle = this.introspector.createPropertyHandle(this.getName(), this.descriptor.getReadMethod());
            }
            catch (IllegalAccessException | RuntimeException e) {
                throw log.errorRetrievingPropertyTypeModel(this.getName(), this.parentTypeModel, e);
            }
        }
        return this.handle;
    }

    Type getGetterGenericReturnType() {
        return this.descriptor.getReadMethod().getGenericReturnType();
    }
}

