/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.javabean.session.impl;

import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import org.hibernate.search.mapper.javabean.mapping.context.impl.JavaBeanMappingContext;
import org.hibernate.search.mapper.javabean.search.SearchScope;
import org.hibernate.search.mapper.javabean.search.impl.SearchScopeImpl;
import org.hibernate.search.mapper.javabean.session.SearchSession;
import org.hibernate.search.mapper.javabean.session.SearchSessionBuilder;
import org.hibernate.search.mapper.javabean.session.context.impl.JavaBeanSessionContext;
import org.hibernate.search.mapper.javabean.work.SearchWorkPlan;
import org.hibernate.search.mapper.javabean.work.impl.SearchWorkPlanImpl;
import org.hibernate.search.mapper.pojo.mapping.spi.PojoMappingDelegate;
import org.hibernate.search.mapper.pojo.model.spi.PojoRuntimeIntrospector;
import org.hibernate.search.mapper.pojo.session.context.spi.AbstractPojoSessionContextImplementor;
import org.hibernate.search.mapper.pojo.session.spi.AbstractPojoSearchSession;

public class JavaBeanSearchSession
extends AbstractPojoSearchSession
implements SearchSession {
    private SearchWorkPlanImpl workPlan;

    private JavaBeanSearchSession(JavaBeanSearchSessionBuilder builder) {
        super((AbstractPojoSearchSession.AbstractBuilder)builder);
    }

    @Override
    public void close() {
        if (this.workPlan != null) {
            CompletableFuture<?> future = this.workPlan.execute();
            future.join();
        }
    }

    @Override
    public SearchScope scope(Collection<? extends Class<?>> targetedTypes) {
        return new SearchScopeImpl(this.getDelegate().createPojoSearchScope(targetedTypes));
    }

    @Override
    public SearchWorkPlan getMainWorkPlan() {
        if (this.workPlan == null) {
            this.workPlan = new SearchWorkPlanImpl(this.getDelegate().createWorkPlan());
        }
        return this.workPlan;
    }

    public static class JavaBeanSearchSessionBuilder
    extends AbstractPojoSearchSession.AbstractBuilder<JavaBeanSearchSession>
    implements SearchSessionBuilder {
        private final JavaBeanMappingContext mappingContext;
        private String tenantId;

        public JavaBeanSearchSessionBuilder(PojoMappingDelegate mappingDelegate, JavaBeanMappingContext mappingContext) {
            super(mappingDelegate);
            this.mappingContext = mappingContext;
        }

        @Override
        public JavaBeanSearchSessionBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        protected AbstractPojoSessionContextImplementor buildSessionContext() {
            return new JavaBeanSessionContext(this.mappingContext, this.tenantId, PojoRuntimeIntrospector.noProxy());
        }

        @Override
        public JavaBeanSearchSession build() {
            return new JavaBeanSearchSession(this);
        }
    }
}

