/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.javabean.model.impl;

import java.beans.IntrospectionException;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.hibernate.search.mapper.javabean.log.impl.Log;
import org.hibernate.search.mapper.javabean.model.impl.JavaBeanGenericContextHelper;
import org.hibernate.search.mapper.javabean.model.impl.JavaBeanTypeModel;
import org.hibernate.search.mapper.pojo.model.spi.GenericContextAwarePojoGenericTypeModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoBootstrapIntrospector;
import org.hibernate.search.mapper.pojo.model.spi.PojoGenericTypeModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.mapper.pojo.model.spi.PropertyHandle;
import org.hibernate.search.mapper.pojo.model.spi.PropertyHandleFactory;
import org.hibernate.search.mapper.pojo.util.spi.AnnotationHelper;
import org.hibernate.search.util.common.impl.ReflectionHelper;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class JavaBeanBootstrapIntrospector
implements PojoBootstrapIntrospector {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final PropertyHandleFactory propertyHandleFactory;
    private final AnnotationHelper annotationHelper;
    private final JavaBeanGenericContextHelper genericContextHelper;
    private final GenericContextAwarePojoGenericTypeModel.RawTypeDeclaringContext<?> missingRawTypeDeclaringContext;
    private final Map<Class<?>, PojoRawTypeModel<?>> typeModelCache = new HashMap();

    public JavaBeanBootstrapIntrospector(MethodHandles.Lookup lookup) {
        this.propertyHandleFactory = PropertyHandleFactory.usingMethodHandle((MethodHandles.Lookup)lookup);
        this.annotationHelper = new AnnotationHelper(lookup);
        this.genericContextHelper = new JavaBeanGenericContextHelper(this);
        this.missingRawTypeDeclaringContext = new GenericContextAwarePojoGenericTypeModel.RawTypeDeclaringContext((GenericContextAwarePojoGenericTypeModel.Helper)this.genericContextHelper, Object.class);
    }

    public <T> PojoRawTypeModel<T> getTypeModel(Class<T> clazz) {
        if (clazz.isPrimitive()) {
            clazz = ReflectionHelper.getPrimitiveWrapperType(clazz);
        }
        return this.typeModelCache.computeIfAbsent(clazz, this::createTypeModel);
    }

    public <T> PojoGenericTypeModel<T> getGenericTypeModel(Class<T> clazz) {
        return this.missingRawTypeDeclaringContext.createGenericTypeModel(clazz);
    }

    <A extends Annotation> Optional<A> getAnnotationByType(AnnotatedElement annotatedElement, Class<A> annotationType) {
        return this.annotationHelper.getAnnotationByType(annotatedElement, annotationType);
    }

    <A extends Annotation> Stream<A> getAnnotationsByType(AnnotatedElement annotatedElement, Class<A> annotationType) {
        return this.annotationHelper.getAnnotationsByType(annotatedElement, annotationType);
    }

    Stream<? extends Annotation> getAnnotationsByMetaAnnotationType(AnnotatedElement annotatedElement, Class<? extends Annotation> metaAnnotationType) {
        return this.annotationHelper.getAnnotationsByMetaAnnotationType(annotatedElement, metaAnnotationType);
    }

    PropertyHandle<?> createPropertyHandle(String name, Method method) throws IllegalAccessException {
        return this.propertyHandleFactory.createForMethod(name, method);
    }

    private <T> PojoRawTypeModel<T> createTypeModel(Class<T> clazz) {
        try {
            return new JavaBeanTypeModel<T>(this, clazz, new GenericContextAwarePojoGenericTypeModel.RawTypeDeclaringContext((GenericContextAwarePojoGenericTypeModel.Helper)this.genericContextHelper, clazz));
        }
        catch (IntrospectionException | RuntimeException e) {
            throw log.errorRetrievingTypeModel(clazz, e);
        }
    }
}

