/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.javabean.search.loading.impl;

import java.lang.invoke.MethodHandles;
import org.hibernate.search.engine.search.DocumentReference;
import org.hibernate.search.engine.search.loading.spi.LoadingResult;
import org.hibernate.search.engine.search.loading.spi.ProjectionHitMapper;
import org.hibernate.search.mapper.javabean.log.impl.Log;
import org.hibernate.search.mapper.pojo.search.PojoReference;
import org.hibernate.search.mapper.pojo.search.spi.PojoSearchScopeDelegate;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class JavaBeanProjectionHitMapper
implements ProjectionHitMapper<PojoReference, Void> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final PojoSearchScopeDelegate<?, ?> scopeDelegate;

    public JavaBeanProjectionHitMapper(PojoSearchScopeDelegate<?, ?> scopeDelegate) {
        this.scopeDelegate = scopeDelegate;
    }

    public PojoReference convertReference(DocumentReference reference) {
        return this.scopeDelegate.toPojoReference(reference);
    }

    public Object planLoading(DocumentReference reference) {
        throw log.cannotLoadEntity(reference);
    }

    public LoadingResult<Void> loadBlocking() {
        return JavaBeanUnusuableLoadingResult.INSTANCE;
    }

    private static class JavaBeanUnusuableLoadingResult
    implements LoadingResult<Void> {
        private static final JavaBeanUnusuableLoadingResult INSTANCE = new JavaBeanUnusuableLoadingResult();

        private JavaBeanUnusuableLoadingResult() {
        }

        public Void getLoaded(Object key) {
            throw new AssertionFailure("Attempt to load an entity with a key that was never issued. There is probably a bug in Hibernate Search, please report it.");
        }
    }
}

