package org.hibernate.search.mapper.javabean.log.impl;

import java.util.Locale;
import java.io.Serializable;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.BasicLogger;
import org.hibernate.search.util.common.SearchException;
import java.lang.String;
import org.jboss.logging.Logger;
import java.util.Arrays;
import java.lang.Exception;
import org.hibernate.search.engine.search.DocumentReference;

/**
 * Warning this class consists of generated code.
 */
public class Log_$logger extends DelegatingBasicLogger implements Log, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    public Log_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    private static final String cannotFindProperty = "HSEARCH750001: Unable to find property '%2$s' on type '%1$s'.";
    protected String cannotFindProperty$str() {
        return cannotFindProperty;
    }
    @Override
    public final SearchException cannotFindProperty(final org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel<?> typeModel, final String propertyName) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotFindProperty$str(), new org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter(typeModel), propertyName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotReadProperty = "HSEARCH750002: Cannot read property '%2$s' on type '%1$s'.";
    protected String cannotReadProperty$str() {
        return cannotReadProperty;
    }
    @Override
    public final SearchException cannotReadProperty(final org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel<?> typeModel, final String propertyName) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotReadProperty$str(), new org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter(typeModel), propertyName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String errorRetrievingTypeModel = "HSEARCH750003: Exception while retrieving the type model for '%1$s'.";
    protected String errorRetrievingTypeModel$str() {
        return errorRetrievingTypeModel;
    }
    @Override
    public final SearchException errorRetrievingTypeModel(final Class<?> clazz, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), errorRetrievingTypeModel$str(), new org.hibernate.search.util.common.logging.impl.ClassFormatter(clazz)), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String errorRetrievingPropertyTypeModel = "HSEARCH750004: Exception while retrieving property type model for '%1$s' on '%2$s'";
    protected String errorRetrievingPropertyTypeModel$str() {
        return errorRetrievingPropertyTypeModel;
    }
    @Override
    public final SearchException errorRetrievingPropertyTypeModel(final String propertyModelName, final org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel<?> parentTypeModel, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), errorRetrievingPropertyTypeModel$str(), propertyModelName, new org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter(parentTypeModel)), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotLoadEntity = "HSEARCH750005: The JavaBean mapper cannot load entities, but there was an attempt to load the entity corresponding to document '%1$s'. There is probably an entity projection in the query definition: it should be removed.";
    protected String cannotLoadEntity$str() {
        return cannotLoadEntity;
    }
    @Override
    public final SearchException cannotLoadEntity(final DocumentReference reference) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotLoadEntity$str(), reference));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}
