/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.javabean.model.impl;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.java.JavaReflectionManager;
import org.hibernate.search.mapper.javabean.log.impl.Log;
import org.hibernate.search.mapper.javabean.model.impl.JavaBeanGenericContextHelper;
import org.hibernate.search.mapper.javabean.model.impl.JavaBeanTypeModel;
import org.hibernate.search.mapper.pojo.model.hcann.spi.AbstractPojoHCAnnBootstrapIntrospector;
import org.hibernate.search.mapper.pojo.model.spi.GenericContextAwarePojoGenericTypeModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoBootstrapIntrospector;
import org.hibernate.search.mapper.pojo.model.spi.PojoGenericTypeModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.util.common.impl.ReflectionHelper;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reflect.spi.AnnotationHelper;
import org.hibernate.search.util.common.reflect.spi.ValueReadHandle;
import org.hibernate.search.util.common.reflect.spi.ValueReadHandleFactory;

public class JavaBeanBootstrapIntrospector
extends AbstractPojoHCAnnBootstrapIntrospector
implements PojoBootstrapIntrospector {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final ValueReadHandleFactory valueReadHandleFactory;
    private final JavaBeanGenericContextHelper genericContextHelper;
    private final GenericContextAwarePojoGenericTypeModel.RawTypeDeclaringContext<?> missingRawTypeDeclaringContext;
    private final Map<Class<?>, PojoRawTypeModel<?>> typeModelCache = new HashMap();

    public static JavaBeanBootstrapIntrospector create(MethodHandles.Lookup lookup) {
        ValueReadHandleFactory valueReadHandleFactory = ValueReadHandleFactory.usingMethodHandle((MethodHandles.Lookup)lookup);
        return new JavaBeanBootstrapIntrospector(valueReadHandleFactory);
    }

    private JavaBeanBootstrapIntrospector(ValueReadHandleFactory valueReadHandleFactory) {
        super((ReflectionManager)new JavaReflectionManager(), new AnnotationHelper(valueReadHandleFactory));
        this.valueReadHandleFactory = valueReadHandleFactory;
        this.genericContextHelper = new JavaBeanGenericContextHelper(this);
        this.missingRawTypeDeclaringContext = new GenericContextAwarePojoGenericTypeModel.RawTypeDeclaringContext((GenericContextAwarePojoGenericTypeModel.Helper)this.genericContextHelper, Object.class);
    }

    public <T> JavaBeanTypeModel<T> getTypeModel(Class<T> clazz) {
        if (clazz.isPrimitive()) {
            clazz = ReflectionHelper.getPrimitiveWrapperType(clazz);
        }
        return (JavaBeanTypeModel)this.typeModelCache.computeIfAbsent(clazz, this::createTypeModel);
    }

    public <T> PojoGenericTypeModel<T> getGenericTypeModel(Class<T> clazz) {
        return this.missingRawTypeDeclaringContext.createGenericTypeModel(clazz);
    }

    <T> Stream<JavaBeanTypeModel<? super T>> getAscendingSuperTypes(XClass xClass) {
        return this.getAscendingSuperClasses(xClass).map(clazz -> this.getTypeModel((Class)clazz));
    }

    <T> Stream<JavaBeanTypeModel<? super T>> getDescendingSuperTypes(XClass xClass) {
        return this.getDescendingSuperClasses(xClass).map(clazz -> this.getTypeModel((Class)clazz));
    }

    ValueReadHandle<?> createValueReadHandle(Method method) throws IllegalAccessException {
        return this.valueReadHandleFactory.createForMethod(method);
    }

    private <T> PojoRawTypeModel<T> createTypeModel(Class<T> clazz) {
        try {
            return new JavaBeanTypeModel<T>(this, clazz, new GenericContextAwarePojoGenericTypeModel.RawTypeDeclaringContext((GenericContextAwarePojoGenericTypeModel.Helper)this.genericContextHelper, clazz));
        }
        catch (RuntimeException e) {
            throw log.errorRetrievingTypeModel(clazz, e);
        }
    }
}

