/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.javabean.model.impl;

import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.hibernate.annotations.common.reflection.XAnnotatedElement;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.search.engine.mapper.model.spi.MappableTypeModel;
import org.hibernate.search.mapper.javabean.log.impl.Log;
import org.hibernate.search.mapper.javabean.model.impl.JavaBeanBootstrapIntrospector;
import org.hibernate.search.mapper.javabean.model.impl.JavaBeanPropertyModel;
import org.hibernate.search.mapper.pojo.model.spi.GenericContextAwarePojoGenericTypeModel;
import org.hibernate.search.mapper.pojo.model.spi.JavaClassPojoCaster;
import org.hibernate.search.mapper.pojo.model.spi.PojoCaster;
import org.hibernate.search.mapper.pojo.model.spi.PojoPropertyModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

class JavaBeanTypeModel<T>
implements PojoRawTypeModel<T> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final JavaBeanBootstrapIntrospector introspector;
    private final Class<T> clazz;
    private final GenericContextAwarePojoGenericTypeModel.RawTypeDeclaringContext<T> rawTypeDeclaringContext;
    private final PojoCaster<T> caster;
    private final XClass xClass;
    private final Map<String, XProperty> declaredProperties;

    JavaBeanTypeModel(JavaBeanBootstrapIntrospector introspector, Class<T> clazz, GenericContextAwarePojoGenericTypeModel.RawTypeDeclaringContext<T> rawTypeDeclaringContext) {
        this.introspector = introspector;
        this.clazz = clazz;
        this.rawTypeDeclaringContext = rawTypeDeclaringContext;
        this.caster = new JavaClassPojoCaster(clazz);
        this.xClass = introspector.toXClass(clazz);
        this.declaredProperties = introspector.getDeclaredMethodAccessXPropertiesByName(this.xClass);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JavaBeanTypeModel that = (JavaBeanTypeModel)o;
        return Objects.equals((Object)this.introspector, (Object)that.introspector) && Objects.equals(this.clazz, that.clazz);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.introspector, this.clazz});
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.clazz.getName() + "]";
    }

    public String getName() {
        return this.clazz.getName();
    }

    public boolean isAbstract() {
        return Modifier.isAbstract(this.clazz.getModifiers());
    }

    public boolean isSubTypeOf(MappableTypeModel other) {
        return other instanceof JavaBeanTypeModel && ((JavaBeanTypeModel)other).clazz.isAssignableFrom(this.clazz);
    }

    public PojoRawTypeModel<? super T> getRawType() {
        return this;
    }

    public boolean isSubTypeOf(Class<?> superClassCandidate) {
        return superClassCandidate.isAssignableFrom(this.clazz);
    }

    public Stream<JavaBeanTypeModel<? super T>> getAscendingSuperTypes() {
        return this.introspector.getAscendingSuperTypes(this.xClass);
    }

    public Stream<? extends PojoRawTypeModel<? super T>> getDescendingSuperTypes() {
        return this.introspector.getDescendingSuperTypes(this.xClass);
    }

    public <A extends Annotation> Optional<A> getAnnotationByType(Class<A> annotationType) {
        return this.introspector.getAnnotationByType((XAnnotatedElement)this.xClass, annotationType);
    }

    public <A extends Annotation> Stream<A> getAnnotationsByType(Class<A> annotationType) {
        return this.introspector.getAnnotationsByType((XAnnotatedElement)this.xClass, annotationType);
    }

    public Stream<? extends Annotation> getAnnotationsByMetaAnnotationType(Class<? extends Annotation> metaAnnotationType) {
        return this.introspector.getAnnotationsByMetaAnnotationType((XAnnotatedElement)this.xClass, metaAnnotationType);
    }

    public PojoPropertyModel<?> getProperty(String propertyName) {
        return this.getAscendingSuperTypes().map(model -> model.declaredProperties.get(propertyName)).filter(Objects::nonNull).findFirst().map(this::createProperty).orElseThrow(() -> log.cannotFindProperty(this, propertyName));
    }

    public Stream<PojoPropertyModel<?>> getDeclaredProperties() {
        return this.declaredProperties.values().stream().map(this::createProperty);
    }

    public PojoCaster<T> getCaster() {
        return this.caster;
    }

    public Class<T> getJavaClass() {
        return this.clazz;
    }

    GenericContextAwarePojoGenericTypeModel.RawTypeDeclaringContext<T> getRawTypeDeclaringContext() {
        return this.rawTypeDeclaringContext;
    }

    private PojoPropertyModel<?> createProperty(XProperty property) {
        return new JavaBeanPropertyModel(this.introspector, this, property);
    }
}

