/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.javabean.session.impl;

import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import org.hibernate.search.engine.backend.work.execution.DocumentCommitStrategy;
import org.hibernate.search.engine.backend.work.execution.DocumentRefreshStrategy;
import org.hibernate.search.engine.search.DocumentReference;
import org.hibernate.search.engine.search.loading.spi.ReferenceHitMapper;
import org.hibernate.search.mapper.javabean.common.EntityReference;
import org.hibernate.search.mapper.javabean.common.impl.EntityReferenceImpl;
import org.hibernate.search.mapper.javabean.mapping.context.impl.JavaBeanMappingContext;
import org.hibernate.search.mapper.javabean.scope.SearchScope;
import org.hibernate.search.mapper.javabean.scope.impl.SearchScopeImpl;
import org.hibernate.search.mapper.javabean.session.SearchSession;
import org.hibernate.search.mapper.javabean.session.SearchSessionBuilder;
import org.hibernate.search.mapper.javabean.session.context.impl.JavaBeanSessionContext;
import org.hibernate.search.mapper.javabean.session.impl.JavaBeanSearchSessionTypeContextProvider;
import org.hibernate.search.mapper.javabean.session.impl.JavaBeanSessionIndexedTypeContext;
import org.hibernate.search.mapper.javabean.work.SearchWorkPlan;
import org.hibernate.search.mapper.javabean.work.impl.SearchWorkPlanImpl;
import org.hibernate.search.mapper.pojo.mapping.spi.PojoMappingDelegate;
import org.hibernate.search.mapper.pojo.model.spi.PojoRuntimeIntrospector;
import org.hibernate.search.mapper.pojo.scope.spi.PojoScopeDelegate;
import org.hibernate.search.mapper.pojo.session.context.spi.AbstractPojoSessionContextImplementor;
import org.hibernate.search.mapper.pojo.session.spi.AbstractPojoSearchSession;
import org.hibernate.search.util.common.AssertionFailure;

public class JavaBeanSearchSession
extends AbstractPojoSearchSession
implements SearchSession,
ReferenceHitMapper<EntityReference> {
    private final JavaBeanSearchSessionTypeContextProvider typeContextProvider;
    private final DocumentCommitStrategy commitStrategy;
    private final DocumentRefreshStrategy refreshStrategy;
    private SearchWorkPlanImpl workPlan;

    private JavaBeanSearchSession(JavaBeanSearchSessionBuilder builder) {
        super((AbstractPojoSearchSession.AbstractBuilder)builder, builder.buildSessionContext());
        this.typeContextProvider = builder.typeContextProvider;
        this.commitStrategy = builder.commitStrategy;
        this.refreshStrategy = builder.refreshStrategy;
    }

    @Override
    public void close() {
        if (this.workPlan != null) {
            CompletableFuture<?> future = this.workPlan.execute();
            future.join();
        }
    }

    @Override
    public SearchScope scope(Collection<? extends Class<?>> targetedTypes) {
        return new SearchScopeImpl(this, (PojoScopeDelegate<EntityReference, Void, Void>)this.getDelegate().createPojoScope(targetedTypes, ignored -> null));
    }

    @Override
    public SearchWorkPlan getMainWorkPlan() {
        if (this.workPlan == null) {
            this.workPlan = new SearchWorkPlanImpl(this.getDelegate().createWorkPlan(this.commitStrategy, this.refreshStrategy));
        }
        return this.workPlan;
    }

    public EntityReference fromDocumentReference(DocumentReference reference) {
        JavaBeanSessionIndexedTypeContext typeContext = this.typeContextProvider.getByIndexName(reference.getIndexName());
        if (typeContext == null) {
            throw new AssertionFailure("Document reference " + reference + " refers to an unknown index");
        }
        Object id = typeContext.getIdentifierMapping().fromDocumentIdentifier(reference.getId(), this.getDelegate().getSessionContext());
        return new EntityReferenceImpl(typeContext.getJavaClass(), id);
    }

    public static class JavaBeanSearchSessionBuilder
    extends AbstractPojoSearchSession.AbstractBuilder<JavaBeanSearchSession>
    implements SearchSessionBuilder {
        private final JavaBeanMappingContext mappingContext;
        private final JavaBeanSearchSessionTypeContextProvider typeContextProvider;
        private String tenantId;
        private DocumentCommitStrategy commitStrategy = DocumentCommitStrategy.FORCE;
        private DocumentRefreshStrategy refreshStrategy = DocumentRefreshStrategy.NONE;

        public JavaBeanSearchSessionBuilder(PojoMappingDelegate mappingDelegate, JavaBeanMappingContext mappingContext, JavaBeanSearchSessionTypeContextProvider typeContextProvider) {
            super(mappingDelegate);
            this.mappingContext = mappingContext;
            this.typeContextProvider = typeContextProvider;
        }

        @Override
        public JavaBeanSearchSessionBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        @Override
        public SearchSessionBuilder commitStrategy(DocumentCommitStrategy commitStrategy) {
            this.commitStrategy = commitStrategy;
            return this;
        }

        @Override
        public SearchSessionBuilder refreshStrategy(DocumentRefreshStrategy refreshStrategy) {
            this.refreshStrategy = refreshStrategy;
            return this;
        }

        protected AbstractPojoSessionContextImplementor buildSessionContext() {
            return new JavaBeanSessionContext(this.mappingContext, this.tenantId, PojoRuntimeIntrospector.noProxy());
        }

        @Override
        public JavaBeanSearchSession build() {
            return new JavaBeanSearchSession(this);
        }
    }
}

