/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.javabean.mapping.impl;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.search.mapper.javabean.mapping.impl.JavaBeanIndexedTypeContext;
import org.hibernate.search.mapper.javabean.session.impl.JavaBeanSearchSessionTypeContextProvider;
import org.hibernate.search.mapper.javabean.session.impl.JavaBeanSessionIndexedTypeContext;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;

class JavaBeanTypeContextContainer
implements JavaBeanSearchSessionTypeContextProvider {
    private final Map<String, JavaBeanIndexedTypeContext<?>> indexedTypeContextsByIndexName = new LinkedHashMap();

    private JavaBeanTypeContextContainer(Builder builder) {
        for (JavaBeanIndexedTypeContext.Builder contextBuilder : builder.indexedTypeContextBuilders) {
            JavaBeanIndexedTypeContext indexedTypeContext = contextBuilder.build();
            this.indexedTypeContextsByIndexName.put(indexedTypeContext.getIndexName(), indexedTypeContext);
        }
    }

    @Override
    public JavaBeanSessionIndexedTypeContext getByIndexName(String indexName) {
        return this.indexedTypeContextsByIndexName.get(indexName);
    }

    static class Builder {
        private final List<JavaBeanIndexedTypeContext.Builder<?>> indexedTypeContextBuilders = new ArrayList();

        Builder() {
        }

        <E> JavaBeanIndexedTypeContext.Builder<E> addIndexed(PojoRawTypeModel<E> typeModel, String indexName) {
            JavaBeanIndexedTypeContext.Builder builder = new JavaBeanIndexedTypeContext.Builder(typeModel.getJavaClass(), indexName);
            this.indexedTypeContextBuilders.add(builder);
            return builder;
        }

        JavaBeanTypeContextContainer build() {
            return new JavaBeanTypeContextContainer(this);
        }
    }
}

