/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.javabean.impl;

import java.lang.invoke.MethodHandles;
import java.util.LinkedHashMap;
import java.util.Map;
import org.hibernate.search.engine.mapper.mapping.building.spi.MappingBuildContext;
import org.hibernate.search.engine.mapper.mapping.building.spi.MappingConfigurationCollector;
import org.hibernate.search.engine.mapper.model.spi.MappableTypeModel;
import org.hibernate.search.mapper.javabean.impl.JavaBeanEntityTypeContributor;
import org.hibernate.search.mapper.javabean.log.impl.Log;
import org.hibernate.search.mapper.javabean.model.impl.JavaBeanBootstrapIntrospector;
import org.hibernate.search.mapper.pojo.mapping.building.spi.PojoTypeMetadataContributor;
import org.hibernate.search.mapper.pojo.mapping.spi.PojoMappingConfigurationContributor;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

class JavaBeanTypeConfigurationContributor
implements PojoMappingConfigurationContributor {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final JavaBeanBootstrapIntrospector introspector;
    private final Map<Class<?>, String> entityNameByType = new LinkedHashMap();
    private final Map<String, Class<?>> entityTypeByName = new LinkedHashMap();

    public JavaBeanTypeConfigurationContributor(JavaBeanBootstrapIntrospector introspector) {
        this.introspector = introspector;
    }

    public void configure(MappingBuildContext buildContext, MappingConfigurationCollector<PojoTypeMetadataContributor> configurationCollector) {
        for (Map.Entry<Class<?>, String> entry : this.entityNameByType.entrySet()) {
            PojoRawTypeModel typeModel = this.introspector.getTypeModel((Class)entry.getKey());
            configurationCollector.collectContributor((MappableTypeModel)typeModel, (Object)new JavaBeanEntityTypeContributor(typeModel.getTypeIdentifier(), entry.getValue()));
        }
    }

    void addEntityType(Class<?> type, String entityName) {
        this.entityNameByType.put(type, entityName);
        Class<?> previousType = this.entityTypeByName.putIfAbsent(entityName, type);
        if (previousType != null && !previousType.equals(type)) {
            throw log.multipleEntityTypesWithSameName(entityName, previousType, type);
        }
    }
}

