/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.javabean.log.impl;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Locale;
import org.hibernate.search.engine.backend.common.DocumentReference;
import org.hibernate.search.mapper.javabean.log.impl.Log;
import org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.logging.impl.ClassFormatter;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;

public class Log_$logger
extends DelegatingBasicLogger
implements Log,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public Log_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String cannotFindProperty$str() {
        return "HSEARCH750001: Unable to find property '%2$s' on type '%1$s'.";
    }

    @Override
    public final SearchException cannotFindProperty(PojoRawTypeModel<?> typeModel, String propertyName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotFindProperty$str(), new PojoTypeModelFormatter(typeModel), propertyName));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    protected String errorRetrievingTypeModel$str() {
        return "HSEARCH750003: Exception while retrieving the type model for '%1$s'.";
    }

    @Override
    public final SearchException errorRetrievingTypeModel(Class<?> clazz, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.errorRetrievingTypeModel$str(), new ClassFormatter(clazz)), (Throwable)cause);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String errorRetrievingPropertyTypeModel$str() {
        return "HSEARCH750004: Exception while retrieving property type model for '%1$s' on '%2$s'";
    }

    @Override
    public final SearchException errorRetrievingPropertyTypeModel(String propertyModelName, PojoRawTypeModel<?> parentTypeModel, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.errorRetrievingPropertyTypeModel$str(), propertyModelName, new PojoTypeModelFormatter(parentTypeModel)), (Throwable)cause);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotLoadEntity$str() {
        return "HSEARCH750005: The JavaBean mapper cannot load entities, but there was an attempt to load the entity corresponding to document '%1$s'. There is probably an entity projection in the query definition: it should be removed.";
    }

    @Override
    public final SearchException cannotLoadEntity(DocumentReference reference) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotLoadEntity$str(), reference));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String multipleEntityTypesWithSameName$str() {
        return "HSEARCH750006: Multiple entity types configured with the same name '%1$s': '%2$s', '%3$s'";
    }

    @Override
    public final SearchException multipleEntityTypesWithSameName(String entityName, Class<?> previousType, Class<?> type) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.multipleEntityTypesWithSameName$str(), entityName, previousType, type));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String namedTypesNotSupported$str() {
        return "HSEARCH750007: The JavaBean mapper does not support named types. The type with name '%1$s' does not exist.";
    }

    @Override
    public final SearchException namedTypesNotSupported(String name) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.namedTypesNotSupported$str(), name));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }
}

