/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.javabean.mapping;

import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.hibernate.search.engine.Version;
import org.hibernate.search.engine.cfg.spi.ConfigurationPropertyChecker;
import org.hibernate.search.engine.cfg.spi.ConfigurationPropertySource;
import org.hibernate.search.engine.common.spi.SearchIntegration;
import org.hibernate.search.engine.common.spi.SearchIntegrationBuilder;
import org.hibernate.search.engine.common.spi.SearchIntegrationFinalizer;
import org.hibernate.search.engine.common.spi.SearchIntegrationPartialBuildState;
import org.hibernate.search.engine.mapper.mapping.building.spi.MappingInitiator;
import org.hibernate.search.engine.mapper.mapping.building.spi.MappingKey;
import org.hibernate.search.mapper.javabean.impl.JavaBeanMappingInitiator;
import org.hibernate.search.mapper.javabean.mapping.CloseableSearchMapping;
import org.hibernate.search.mapper.javabean.mapping.SearchMapping;
import org.hibernate.search.mapper.javabean.mapping.impl.JavaBeanMapping;
import org.hibernate.search.mapper.javabean.mapping.impl.JavaBeanMappingKey;
import org.hibernate.search.mapper.javabean.model.impl.JavaBeanBootstrapIntrospector;
import org.hibernate.search.mapper.pojo.extractor.ContainerExtractorConfigurationContext;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.AnnotationMappingConfigurationContext;
import org.hibernate.search.mapper.pojo.mapping.definition.programmatic.ProgrammaticMappingConfigurationContext;
import org.hibernate.search.util.common.impl.SuppressingCloser;

public final class SearchMappingBuilder {
    private final ConfigurationPropertyChecker propertyChecker;
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private final ConfigurationPropertySource propertySource;
    private final SearchIntegrationBuilder integrationBuilder;
    private final JavaBeanMappingKey mappingKey;
    private final JavaBeanMappingInitiator mappingInitiator;

    private static ConfigurationPropertySource getPropertySource(Map<String, Object> properties, ConfigurationPropertyChecker propertyChecker) {
        return propertyChecker.wrap(ConfigurationPropertySource.fromMap(properties));
    }

    SearchMappingBuilder(MethodHandles.Lookup lookup) {
        this.propertyChecker = ConfigurationPropertyChecker.create();
        this.propertySource = SearchMappingBuilder.getPropertySource(this.properties, this.propertyChecker);
        this.integrationBuilder = SearchIntegration.builder((ConfigurationPropertySource)this.propertySource, (ConfigurationPropertyChecker)this.propertyChecker);
        JavaBeanBootstrapIntrospector introspector = JavaBeanBootstrapIntrospector.create(lookup);
        this.mappingKey = new JavaBeanMappingKey();
        this.mappingInitiator = new JavaBeanMappingInitiator(introspector);
        this.integrationBuilder.addMappingInitiator((MappingKey)this.mappingKey, (MappingInitiator)this.mappingInitiator);
        this.mappingInitiator.setAnnotatedTypeDiscoveryEnabled(true);
    }

    public ProgrammaticMappingConfigurationContext programmaticMapping() {
        return this.mappingInitiator.programmaticMapping();
    }

    public AnnotationMappingConfigurationContext annotationMapping() {
        return this.mappingInitiator.annotationMapping();
    }

    public ContainerExtractorConfigurationContext containerExtractors() {
        return this.mappingInitiator.containerExtractors();
    }

    public SearchMappingBuilder addEntityType(Class<?> type) {
        return this.addEntityType(type, type.getSimpleName());
    }

    public SearchMappingBuilder addEntityType(Class<?> type, String entityName) {
        this.mappingInitiator.addEntityType(type, entityName);
        return this;
    }

    public SearchMappingBuilder addEntityTypes(Set<Class<?>> types) {
        for (Class<?> type : types) {
            this.addEntityType(type);
        }
        return this;
    }

    public SearchMappingBuilder setMultiTenancyEnabled(boolean multiTenancyEnabled) {
        this.mappingInitiator.setMultiTenancyEnabled(multiTenancyEnabled);
        return this;
    }

    public SearchMappingBuilder setImplicitProvidedId(boolean multiTenancyEnabled) {
        this.mappingInitiator.setImplicitProvidedId(multiTenancyEnabled);
        return this;
    }

    public SearchMappingBuilder setAnnotatedTypeDiscoveryEnabled(boolean annotatedTypeDiscoveryEnabled) {
        this.mappingInitiator.setAnnotatedTypeDiscoveryEnabled(annotatedTypeDiscoveryEnabled);
        return this;
    }

    public SearchMappingBuilder setProperty(String name, Object value) {
        this.properties.put(name, value);
        return this;
    }

    public SearchMappingBuilder setProperties(Map<String, Object> map) {
        this.properties.putAll(map);
        return this;
    }

    public CloseableSearchMapping build() {
        SearchMapping mapping;
        Version.logVersion();
        SearchIntegrationPartialBuildState integrationPartialBuildState = this.integrationBuilder.prepareBuild();
        SearchIntegration integration = null;
        try {
            SearchIntegrationFinalizer finalizer = integrationPartialBuildState.finalizer(this.propertySource, this.propertyChecker);
            mapping = (SearchMapping)finalizer.finalizeMapping((MappingKey)this.mappingKey, (context, partialMapping) -> partialMapping.finalizeMapping());
            integration = finalizer.finalizeIntegration();
        }
        catch (RuntimeException e) {
            new SuppressingCloser((Throwable)e).push(SearchIntegrationPartialBuildState::closeOnFailure, (Object)integrationPartialBuildState);
            throw e;
        }
        try {
            JavaBeanMapping mappingImpl = (JavaBeanMapping)mapping;
            mappingImpl.onClose(() -> ((SearchIntegration)integration).close());
            return mappingImpl;
        }
        catch (RuntimeException e) {
            new SuppressingCloser((Throwable)e).push((AutoCloseable)integration);
            throw e;
        }
    }
}

