/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.javabean.mapping.impl;

import java.util.ArrayList;
import java.util.Collection;
import org.hibernate.search.mapper.javabean.common.EntityReference;
import org.hibernate.search.mapper.javabean.mapping.CloseableSearchMapping;
import org.hibernate.search.mapper.javabean.mapping.SearchMapping;
import org.hibernate.search.mapper.javabean.mapping.context.impl.JavaBeanBackendMappingContext;
import org.hibernate.search.mapper.javabean.mapping.impl.JavaBeanTypeContextContainer;
import org.hibernate.search.mapper.javabean.scope.SearchScope;
import org.hibernate.search.mapper.javabean.scope.impl.SearchScopeImpl;
import org.hibernate.search.mapper.javabean.session.SearchSession;
import org.hibernate.search.mapper.javabean.session.SearchSessionBuilder;
import org.hibernate.search.mapper.javabean.session.impl.JavaBeanSearchSession;
import org.hibernate.search.mapper.javabean.session.impl.JavaBeanSearchSessionMappingContext;
import org.hibernate.search.mapper.pojo.mapping.context.spi.AbstractPojoBackendMappingContext;
import org.hibernate.search.mapper.pojo.mapping.spi.AbstractPojoMappingImplementor;
import org.hibernate.search.mapper.pojo.mapping.spi.PojoMappingDelegate;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeIdentifier;
import org.hibernate.search.mapper.pojo.scope.spi.PojoScopeDelegate;

public class JavaBeanMapping
extends AbstractPojoMappingImplementor<SearchMapping>
implements CloseableSearchMapping,
JavaBeanSearchSessionMappingContext {
    private final JavaBeanBackendMappingContext backendMappingContext = new JavaBeanBackendMappingContext();
    private final JavaBeanTypeContextContainer typeContextContainer;

    JavaBeanMapping(PojoMappingDelegate mappingDelegate, JavaBeanTypeContextContainer typeContextContainer) {
        super(mappingDelegate);
        this.typeContextContainer = typeContextContainer;
    }

    @Override
    public SearchScope scope(Collection<? extends Class<?>> targetedTypes) {
        return this.createScope(targetedTypes);
    }

    public SearchMapping toConcreteType() {
        return this;
    }

    @Override
    public SearchSession createSession() {
        return this.createSearchManagerBuilder().build();
    }

    @Override
    public SearchSessionBuilder createSessionWithOptions() {
        return this.createSearchManagerBuilder();
    }

    @Override
    public JavaBeanBackendMappingContext getBackendMappingContext() {
        return this.backendMappingContext;
    }

    @Override
    public SearchScopeImpl createScope(Collection<? extends Class<?>> classes) {
        ArrayList<PojoRawTypeIdentifier> typeIdentifiers = new ArrayList<PojoRawTypeIdentifier>(classes.size());
        for (Class<?> clazz : classes) {
            typeIdentifiers.add(PojoRawTypeIdentifier.of(clazz));
        }
        return new SearchScopeImpl((PojoScopeDelegate<EntityReference, Void, Void>)this.getDelegate().createPojoScope((AbstractPojoBackendMappingContext)this.backendMappingContext, typeIdentifiers, ignored -> null));
    }

    private SearchSessionBuilder createSearchManagerBuilder() {
        return new JavaBeanSearchSession.JavaBeanSearchSessionBuilder(this.getDelegate(), this, this.typeContextContainer);
    }
}

