/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.javabean.mapping.impl;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.search.mapper.javabean.mapping.impl.JavaBeanIndexedTypeContext;
import org.hibernate.search.mapper.javabean.session.impl.JavaBeanSearchSessionTypeContextProvider;
import org.hibernate.search.mapper.javabean.session.impl.JavaBeanSessionIndexedTypeContext;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;

class JavaBeanTypeContextContainer
implements JavaBeanSearchSessionTypeContextProvider {
    private final Map<String, JavaBeanIndexedTypeContext<?>> indexedTypeContextsByEntityName = new LinkedHashMap();

    private JavaBeanTypeContextContainer(Builder builder) {
        for (JavaBeanIndexedTypeContext.Builder contextBuilder : builder.indexedTypeContextBuilders) {
            JavaBeanIndexedTypeContext indexedTypeContext = contextBuilder.build();
            this.indexedTypeContextsByEntityName.put(indexedTypeContext.getEntityName(), indexedTypeContext);
        }
    }

    @Override
    public JavaBeanSessionIndexedTypeContext<?> getIndexedByEntityName(String indexName) {
        return this.indexedTypeContextsByEntityName.get(indexName);
    }

    static class Builder {
        private final List<JavaBeanIndexedTypeContext.Builder<?>> indexedTypeContextBuilders = new ArrayList();

        Builder() {
        }

        <E> JavaBeanIndexedTypeContext.Builder<E> addIndexed(PojoRawTypeModel<E> typeModel, String entityName) {
            JavaBeanIndexedTypeContext.Builder builder = new JavaBeanIndexedTypeContext.Builder(typeModel.getTypeIdentifier(), entityName);
            this.indexedTypeContextBuilders.add(builder);
            return builder;
        }

        JavaBeanTypeContextContainer build() {
            return new JavaBeanTypeContextContainer(this);
        }
    }
}

