/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.javabean.model.impl;

import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Objects;
import java.util.stream.Stream;
import org.hibernate.annotations.common.reflection.XAnnotatedElement;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.search.mapper.javabean.log.impl.Log;
import org.hibernate.search.mapper.javabean.model.impl.JavaBeanBootstrapIntrospector;
import org.hibernate.search.mapper.javabean.model.impl.JavaBeanTypeModel;
import org.hibernate.search.mapper.pojo.model.hcann.spi.PojoCommonsAnnotationsHelper;
import org.hibernate.search.mapper.pojo.model.spi.PojoGenericTypeModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoPropertyModel;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reflect.spi.ValueReadHandle;

class JavaBeanPropertyModel<T>
implements PojoPropertyModel<T> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final JavaBeanBootstrapIntrospector introspector;
    private final JavaBeanTypeModel<?> parentTypeModel;
    private final XProperty property;
    private final Method readMethod;
    private PojoGenericTypeModel<T> typeModel;
    private ValueReadHandle<T> handle;

    JavaBeanPropertyModel(JavaBeanBootstrapIntrospector introspector, JavaBeanTypeModel<?> parentTypeModel, XProperty property) {
        this.introspector = introspector;
        this.parentTypeModel = parentTypeModel;
        this.property = property;
        this.readMethod = PojoCommonsAnnotationsHelper.getUnderlyingMethod((XProperty)property);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JavaBeanPropertyModel that = (JavaBeanPropertyModel)o;
        return Objects.equals((Object)this.introspector, (Object)that.introspector) && Objects.equals(this.parentTypeModel, that.parentTypeModel) && Objects.equals(this.getHandle(), that.getHandle());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.introspector, this.parentTypeModel, this.handle});
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getName() + ", " + this.getGetterGenericReturnType().getTypeName() + "]";
    }

    public String getName() {
        return this.property.getName();
    }

    public Stream<Annotation> getAnnotations() {
        return this.introspector.getAnnotations((XAnnotatedElement)this.property);
    }

    public PojoGenericTypeModel<T> getTypeModel() {
        if (this.typeModel == null) {
            try {
                this.typeModel = this.parentTypeModel.getRawTypeDeclaringContext().createGenericTypeModel(this.getGetterGenericReturnType());
            }
            catch (RuntimeException e) {
                throw log.errorRetrievingPropertyTypeModel(this.getName(), this.parentTypeModel, e);
            }
        }
        return this.typeModel;
    }

    public ValueReadHandle<T> getHandle() {
        if (this.handle == null) {
            try {
                this.handle = this.introspector.createValueReadHandle(this.readMethod);
            }
            catch (IllegalAccessException | RuntimeException e) {
                throw log.errorRetrievingPropertyTypeModel(this.getName(), this.parentTypeModel, e);
            }
        }
        return this.handle;
    }

    Type getGetterGenericReturnType() {
        return this.readMethod.getGenericReturnType();
    }
}

