/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.javabean.model.impl;

import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.hibernate.annotations.common.reflection.XAnnotatedElement;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.search.engine.mapper.model.spi.MappableTypeModel;
import org.hibernate.search.mapper.javabean.log.impl.Log;
import org.hibernate.search.mapper.javabean.model.impl.JavaBeanBootstrapIntrospector;
import org.hibernate.search.mapper.javabean.model.impl.JavaBeanPropertyModel;
import org.hibernate.search.mapper.pojo.model.spi.GenericContextAwarePojoGenericTypeModel;
import org.hibernate.search.mapper.pojo.model.spi.JavaClassPojoCaster;
import org.hibernate.search.mapper.pojo.model.spi.PojoCaster;
import org.hibernate.search.mapper.pojo.model.spi.PojoPropertyModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeIdentifier;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

class JavaBeanTypeModel<T>
implements PojoRawTypeModel<T> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final JavaBeanBootstrapIntrospector introspector;
    private final PojoRawTypeIdentifier<T> typeIdentifier;
    private final GenericContextAwarePojoGenericTypeModel.RawTypeDeclaringContext<T> rawTypeDeclaringContext;
    private final PojoCaster<T> caster;
    private final XClass xClass;
    private final Map<String, XProperty> declaredProperties;

    JavaBeanTypeModel(JavaBeanBootstrapIntrospector introspector, PojoRawTypeIdentifier<T> typeIdentifier, GenericContextAwarePojoGenericTypeModel.RawTypeDeclaringContext<T> rawTypeDeclaringContext) {
        this.introspector = introspector;
        this.typeIdentifier = typeIdentifier;
        this.rawTypeDeclaringContext = rawTypeDeclaringContext;
        this.caster = new JavaClassPojoCaster(typeIdentifier.getJavaClass());
        this.xClass = introspector.toXClass(typeIdentifier.getJavaClass());
        this.declaredProperties = introspector.getDeclaredMethodAccessXPropertiesByName(this.xClass);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JavaBeanTypeModel that = (JavaBeanTypeModel)o;
        return Objects.equals((Object)this.introspector, (Object)that.introspector) && Objects.equals(this.typeIdentifier, that.typeIdentifier);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.introspector, this.typeIdentifier});
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.typeIdentifier + "]";
    }

    public PojoRawTypeIdentifier<T> getTypeIdentifier() {
        return this.typeIdentifier;
    }

    public String getName() {
        return this.typeIdentifier.toString();
    }

    public boolean isAbstract() {
        return Modifier.isAbstract(this.typeIdentifier.getJavaClass().getModifiers());
    }

    public boolean isSubTypeOf(MappableTypeModel other) {
        return other instanceof JavaBeanTypeModel && ((JavaBeanTypeModel)other).typeIdentifier.getJavaClass().isAssignableFrom(this.typeIdentifier.getJavaClass());
    }

    public PojoRawTypeModel<? super T> getRawType() {
        return this;
    }

    public Stream<JavaBeanTypeModel<? super T>> getAscendingSuperTypes() {
        return this.introspector.getAscendingSuperTypes(this.xClass);
    }

    public Stream<? extends PojoRawTypeModel<? super T>> getDescendingSuperTypes() {
        return this.introspector.getDescendingSuperTypes(this.xClass);
    }

    public Stream<Annotation> getAnnotations() {
        return this.introspector.getAnnotations((XAnnotatedElement)this.xClass);
    }

    public PojoPropertyModel<?> getProperty(String propertyName) {
        return this.getAscendingSuperTypes().map(model -> model.declaredProperties.get(propertyName)).filter(Objects::nonNull).findFirst().map(this::createProperty).orElseThrow(() -> log.cannotFindProperty(this, propertyName));
    }

    public Stream<PojoPropertyModel<?>> getDeclaredProperties() {
        return this.declaredProperties.values().stream().map(this::createProperty);
    }

    public PojoCaster<T> getCaster() {
        return this.caster;
    }

    GenericContextAwarePojoGenericTypeModel.RawTypeDeclaringContext<T> getRawTypeDeclaringContext() {
        return this.rawTypeDeclaringContext;
    }

    private PojoPropertyModel<?> createProperty(XProperty property) {
        return new JavaBeanPropertyModel(this.introspector, this, property);
    }
}

