/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.javabean.search.loading.impl;

import java.lang.invoke.MethodHandles;
import org.hibernate.search.engine.backend.common.DocumentReference;
import org.hibernate.search.engine.backend.common.spi.DocumentReferenceConverter;
import org.hibernate.search.engine.search.loading.spi.LoadingResult;
import org.hibernate.search.engine.search.loading.spi.ProjectionHitMapper;
import org.hibernate.search.mapper.javabean.common.EntityReference;
import org.hibernate.search.mapper.javabean.log.impl.Log;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class JavaBeanProjectionHitMapper
implements ProjectionHitMapper<EntityReference, Void> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final DocumentReferenceConverter<EntityReference> documentReferenceConverter;

    public JavaBeanProjectionHitMapper(DocumentReferenceConverter<EntityReference> documentReferenceConverter) {
        this.documentReferenceConverter = documentReferenceConverter;
    }

    public EntityReference convertReference(DocumentReference reference) {
        return (EntityReference)this.documentReferenceConverter.fromDocumentReference(reference);
    }

    public Object planLoading(DocumentReference reference) {
        throw log.cannotLoadEntity(reference);
    }

    public LoadingResult<Void> loadBlocking() {
        return JavaBeanUnusuableLoadingResult.INSTANCE;
    }

    private static class JavaBeanUnusuableLoadingResult
    implements LoadingResult<Void> {
        private static final JavaBeanUnusuableLoadingResult INSTANCE = new JavaBeanUnusuableLoadingResult();

        private JavaBeanUnusuableLoadingResult() {
        }

        public Void getLoaded(Object key) {
            throw new AssertionFailure("Attempt to load an entity with a key that was never issued. There is probably a bug in Hibernate Search, please report it.");
        }
    }
}

