/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.javabean.session.impl;

import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import org.hibernate.search.engine.backend.common.DocumentReference;
import org.hibernate.search.engine.backend.common.spi.DocumentReferenceConverter;
import org.hibernate.search.engine.backend.session.spi.BackendSessionContext;
import org.hibernate.search.engine.backend.work.execution.DocumentCommitStrategy;
import org.hibernate.search.engine.backend.work.execution.DocumentRefreshStrategy;
import org.hibernate.search.engine.search.query.dsl.SearchQueryHitTypeStep;
import org.hibernate.search.mapper.javabean.common.EntityReference;
import org.hibernate.search.mapper.javabean.common.impl.EntityReferenceImpl;
import org.hibernate.search.mapper.javabean.scope.SearchScope;
import org.hibernate.search.mapper.javabean.scope.impl.SearchScopeImpl;
import org.hibernate.search.mapper.javabean.session.SearchSession;
import org.hibernate.search.mapper.javabean.session.SearchSessionBuilder;
import org.hibernate.search.mapper.javabean.session.context.impl.JavaBeanBackendSessionContext;
import org.hibernate.search.mapper.javabean.session.impl.JavaBeanSearchSessionMappingContext;
import org.hibernate.search.mapper.javabean.session.impl.JavaBeanSearchSessionTypeContextProvider;
import org.hibernate.search.mapper.javabean.session.impl.JavaBeanSessionIndexedTypeContext;
import org.hibernate.search.mapper.javabean.work.SearchIndexingPlan;
import org.hibernate.search.mapper.javabean.work.impl.SearchIndexingPlanImpl;
import org.hibernate.search.mapper.pojo.mapping.spi.PojoMappingDelegate;
import org.hibernate.search.mapper.pojo.model.spi.PojoRuntimeIntrospector;
import org.hibernate.search.mapper.pojo.session.context.spi.AbstractPojoBackendSessionContext;
import org.hibernate.search.mapper.pojo.session.spi.AbstractPojoSearchSession;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.impl.Futures;

public class JavaBeanSearchSession
extends AbstractPojoSearchSession
implements SearchSession,
DocumentReferenceConverter<EntityReference> {
    private final JavaBeanSearchSessionMappingContext mappingContext;
    private final JavaBeanSearchSessionTypeContextProvider typeContextProvider;
    private final DocumentCommitStrategy commitStrategy;
    private final DocumentRefreshStrategy refreshStrategy;
    private SearchIndexingPlanImpl indexingPlan;

    private JavaBeanSearchSession(JavaBeanSearchSessionBuilder builder) {
        super((AbstractPojoSearchSession.AbstractBuilder)builder, builder.buildSessionContext());
        this.mappingContext = builder.mappingContext;
        this.typeContextProvider = builder.typeContextProvider;
        this.commitStrategy = builder.commitStrategy;
        this.refreshStrategy = builder.refreshStrategy;
    }

    @Override
    public void close() {
        if (this.indexingPlan != null) {
            CompletableFuture<?> future = this.indexingPlan.execute();
            Futures.unwrappedExceptionJoin(future);
        }
    }

    @Override
    public SearchQueryHitTypeStep<?, EntityReference, ?, ?, ?> search(Collection<? extends Class<?>> types) {
        return this.search((SearchScopeImpl)this.scope((Collection)types));
    }

    @Override
    public SearchQueryHitTypeStep<?, EntityReference, ?, ?, ?> search(SearchScope scope) {
        return this.search((SearchScopeImpl)scope);
    }

    @Override
    public SearchScopeImpl scope(Collection<? extends Class<?>> types) {
        return this.mappingContext.createScope(types);
    }

    @Override
    public SearchIndexingPlan indexingPlan() {
        if (this.indexingPlan == null) {
            this.indexingPlan = new SearchIndexingPlanImpl(this.getDelegate().getBackendSessionContext().getRuntimeIntrospector(), this.getDelegate().createIndexingPlan(this.commitStrategy, this.refreshStrategy));
        }
        return this.indexingPlan;
    }

    public EntityReference fromDocumentReference(DocumentReference reference) {
        JavaBeanSessionIndexedTypeContext<?> typeContext = this.typeContextProvider.getIndexedByEntityName(reference.getTypeName());
        if (typeContext == null) {
            throw new AssertionFailure("Document reference " + reference + " refers to an unknown type");
        }
        Object id = typeContext.getIdentifierMapping().fromDocumentIdentifier(reference.getId(), this.getDelegate().getBackendSessionContext());
        return new EntityReferenceImpl(typeContext.getTypeIdentifier(), typeContext.getEntityName(), id);
    }

    private SearchQueryHitTypeStep<?, EntityReference, ?, ?, ?> search(SearchScopeImpl scope) {
        return scope.search((BackendSessionContext)this.getDelegate().getBackendSessionContext(), this);
    }

    public static class JavaBeanSearchSessionBuilder
    extends AbstractPojoSearchSession.AbstractBuilder<JavaBeanSearchSession>
    implements SearchSessionBuilder {
        private final JavaBeanSearchSessionMappingContext mappingContext;
        private final JavaBeanSearchSessionTypeContextProvider typeContextProvider;
        private String tenantId;
        private DocumentCommitStrategy commitStrategy = DocumentCommitStrategy.FORCE;
        private DocumentRefreshStrategy refreshStrategy = DocumentRefreshStrategy.NONE;

        public JavaBeanSearchSessionBuilder(PojoMappingDelegate mappingDelegate, JavaBeanSearchSessionMappingContext mappingContext, JavaBeanSearchSessionTypeContextProvider typeContextProvider) {
            super(mappingDelegate);
            this.mappingContext = mappingContext;
            this.typeContextProvider = typeContextProvider;
        }

        @Override
        public JavaBeanSearchSessionBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        @Override
        public SearchSessionBuilder commitStrategy(DocumentCommitStrategy commitStrategy) {
            this.commitStrategy = commitStrategy;
            return this;
        }

        @Override
        public SearchSessionBuilder refreshStrategy(DocumentRefreshStrategy refreshStrategy) {
            this.refreshStrategy = refreshStrategy;
            return this;
        }

        protected AbstractPojoBackendSessionContext buildSessionContext() {
            return new JavaBeanBackendSessionContext(this.mappingContext.getBackendMappingContext(), this.tenantId, PojoRuntimeIntrospector.simple());
        }

        @Override
        public JavaBeanSearchSession build() {
            return new JavaBeanSearchSession(this);
        }
    }
}

