/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.javabean.work.impl;

import java.util.concurrent.CompletableFuture;
import org.hibernate.search.mapper.javabean.work.SearchIndexingPlan;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeIdentifier;
import org.hibernate.search.mapper.pojo.model.spi.PojoRuntimeIntrospector;
import org.hibernate.search.mapper.pojo.work.spi.PojoIndexingPlan;
import org.hibernate.search.util.common.impl.Throwables;

public class SearchIndexingPlanImpl
implements SearchIndexingPlan {
    private final PojoRuntimeIntrospector introspector;
    private final PojoIndexingPlan delegate;

    public SearchIndexingPlanImpl(PojoRuntimeIntrospector introspector, PojoIndexingPlan delegate) {
        this.introspector = introspector;
        this.delegate = delegate;
    }

    @Override
    public void add(Object entity) {
        this.add(null, entity);
    }

    @Override
    public void add(Object providedId, Object entity) {
        this.delegate.add(this.getTypeIdentifier(entity), providedId, entity);
    }

    @Override
    public void addOrUpdate(Object entity) {
        this.addOrUpdate(null, entity);
    }

    @Override
    public void addOrUpdate(Object providedId, Object entity) {
        this.delegate.addOrUpdate(this.getTypeIdentifier(entity), providedId, entity);
    }

    @Override
    public void addOrUpdate(Object entity, String ... dirtyPaths) {
        this.addOrUpdate(null, entity, dirtyPaths);
    }

    @Override
    public void addOrUpdate(Object providedId, Object entity, String ... dirtyPaths) {
        this.delegate.addOrUpdate(this.getTypeIdentifier(entity), providedId, entity, dirtyPaths);
    }

    @Override
    public void delete(Object entity) {
        this.delete(null, entity);
    }

    @Override
    public void delete(Object providedId, Object entity) {
        this.delegate.delete(this.getTypeIdentifier(entity), providedId, entity);
    }

    public CompletableFuture<?> execute() {
        return this.delegate.executeAndReport().thenApply(report -> {
            report.getThrowable().ifPresent(t -> {
                throw Throwables.toRuntimeException((Throwable)t);
            });
            return null;
        });
    }

    private <T> PojoRawTypeIdentifier<? extends T> getTypeIdentifier(T entity) {
        return this.introspector.getEntityTypeIdentifier(entity);
    }
}

