/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.bridge.binding.impl;

import org.hibernate.search.engine.backend.types.converter.ToDocumentFieldValueConverter;
import org.hibernate.search.engine.backend.types.converter.runtime.ToDocumentFieldValueConvertContext;
import org.hibernate.search.engine.backend.types.converter.runtime.ToDocumentFieldValueConvertContextExtension;
import org.hibernate.search.mapper.pojo.bridge.ValueBridge;
import org.hibernate.search.mapper.pojo.bridge.binding.impl.PojoValueBridgeContextExtension;
import org.hibernate.search.mapper.pojo.bridge.runtime.ValueBridgeToIndexedValueContext;

final class PojoValueBridgeToDocumentFieldValueConverter<V, F>
implements ToDocumentFieldValueConverter<V, F> {
    private final ValueBridge<V, F> bridge;
    private final Class<V> expectedValueType;

    PojoValueBridgeToDocumentFieldValueConverter(ValueBridge<V, F> bridge, Class<V> expectedValueType) {
        this.bridge = bridge;
        this.expectedValueType = expectedValueType;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[bridge=" + this.bridge + ", expectedValueType=" + this.expectedValueType + "]";
    }

    public boolean isValidInputType(Class<?> inputTypeCandidate) {
        return this.expectedValueType.isAssignableFrom(inputTypeCandidate);
    }

    public F convert(V value, ToDocumentFieldValueConvertContext context) {
        return this.bridge.toIndexedValue(value, (ValueBridgeToIndexedValueContext)context.extension((ToDocumentFieldValueConvertContextExtension)PojoValueBridgeContextExtension.INSTANCE));
    }

    public F convertUnknown(Object value, ToDocumentFieldValueConvertContext context) {
        return this.bridge.toIndexedValue(this.expectedValueType.cast(value), (ValueBridgeToIndexedValueContext)context.extension((ToDocumentFieldValueConvertContextExtension)PojoValueBridgeContextExtension.INSTANCE));
    }

    public boolean isCompatibleWith(ToDocumentFieldValueConverter<?, ?> other) {
        if (other == null || !this.getClass().equals(other.getClass())) {
            return false;
        }
        PojoValueBridgeToDocumentFieldValueConverter castedOther = (PojoValueBridgeToDocumentFieldValueConverter)other;
        return this.expectedValueType.equals(castedOther.expectedValueType) && this.bridge.isCompatibleWith(castedOther.bridge);
    }
}

