/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.processing.impl;

import org.hibernate.search.engine.backend.document.DocumentElement;
import org.hibernate.search.engine.backend.document.IndexFieldReference;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.mapper.pojo.bridge.ValueBridge;
import org.hibernate.search.mapper.pojo.processing.impl.PojoIndexingProcessor;
import org.hibernate.search.mapper.pojo.session.context.spi.AbstractPojoBackendSessionContext;
import org.hibernate.search.util.common.impl.Closer;
import org.hibernate.search.util.common.impl.ToStringTreeBuilder;

public class PojoIndexingProcessorValueBridgeNode<V, F>
extends PojoIndexingProcessor<V> {
    private final BeanHolder<? extends ValueBridge<? super V, F>> bridgeHolder;
    private final IndexFieldReference<F> indexFieldReference;

    public PojoIndexingProcessorValueBridgeNode(BeanHolder<? extends ValueBridge<? super V, F>> bridgeHolder, IndexFieldReference<F> indexFieldReference) {
        this.bridgeHolder = bridgeHolder;
        this.indexFieldReference = indexFieldReference;
    }

    @Override
    public void close() {
        try (Closer closer = new Closer();){
            closer.push(holder -> ((ValueBridge)holder.get()).close(), this.bridgeHolder);
            closer.push(BeanHolder::close, this.bridgeHolder);
        }
    }

    public void appendTo(ToStringTreeBuilder builder) {
        builder.attribute("class", (Object)this.getClass().getSimpleName());
        builder.attribute("bridge", this.bridgeHolder);
        builder.attribute("indexFieldReference", this.indexFieldReference);
    }

    @Override
    public void process(DocumentElement target, V source, AbstractPojoBackendSessionContext sessionContext) {
        Object indexFieldValue = ((ValueBridge)this.bridgeHolder.get()).toIndexedValue(source, sessionContext.getMappingContext().getToIndexedValueContext());
        target.addValue(this.indexFieldReference, indexFieldValue);
    }
}

