/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.bridge.binding.impl;

import java.lang.invoke.MethodHandles;
import org.hibernate.search.engine.backend.types.dsl.IndexFieldTypeOptionsStep;
import org.hibernate.search.engine.backend.types.dsl.ScaledNumberIndexFieldTypeOptionsStep;
import org.hibernate.search.engine.backend.types.dsl.StandardIndexFieldTypeOptionsStep;
import org.hibernate.search.engine.backend.types.dsl.StringIndexFieldTypeOptionsStep;
import org.hibernate.search.mapper.pojo.bridge.ValueBridge;
import org.hibernate.search.mapper.pojo.bridge.binding.spi.FieldModelContributorContext;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

final class FieldModelContributorContextImpl<F>
implements FieldModelContributorContext {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final ValueBridge<?, F> bridge;
    private final IndexFieldTypeOptionsStep<?, ? super F> fieldTypeOptionsStep;

    FieldModelContributorContextImpl(ValueBridge<?, F> bridge, IndexFieldTypeOptionsStep<?, ? super F> fieldTypeOptionsStep) {
        this.bridge = bridge;
        this.fieldTypeOptionsStep = fieldTypeOptionsStep;
    }

    @Override
    public void indexNullAs(String value) {
        this.getStandardTypeOptionsStep().indexNullAs(this.bridge.parse(value));
    }

    public StandardIndexFieldTypeOptionsStep<?, ? super F> getStandardTypeOptionsStep() {
        if (this.fieldTypeOptionsStep instanceof StandardIndexFieldTypeOptionsStep) {
            return (StandardIndexFieldTypeOptionsStep)this.fieldTypeOptionsStep;
        }
        throw log.invalidFieldEncodingForStandardFieldMapping(this.fieldTypeOptionsStep, StandardIndexFieldTypeOptionsStep.class);
    }

    @Override
    public StringIndexFieldTypeOptionsStep<?> getStringTypeOptionsStep() {
        if (this.fieldTypeOptionsStep instanceof StringIndexFieldTypeOptionsStep) {
            return (StringIndexFieldTypeOptionsStep)this.fieldTypeOptionsStep;
        }
        throw log.invalidFieldEncodingForStringFieldMapping(this.fieldTypeOptionsStep, StringIndexFieldTypeOptionsStep.class);
    }

    @Override
    public ScaledNumberIndexFieldTypeOptionsStep<?, ?> getScaledNumberTypeOptionsStep() {
        if (this.fieldTypeOptionsStep instanceof ScaledNumberIndexFieldTypeOptionsStep) {
            return (ScaledNumberIndexFieldTypeOptionsStep)this.fieldTypeOptionsStep;
        }
        throw log.invalidFieldEncodingForScaledNumberFieldMapping(this.fieldTypeOptionsStep, ScaledNumberIndexFieldTypeOptionsStep.class);
    }

    @Override
    public void checkNonStandardTypeOptionsStep() {
        if (this.fieldTypeOptionsStep instanceof StandardIndexFieldTypeOptionsStep) {
            throw log.invalidFieldEncodingForNonStandardFieldMapping(this.fieldTypeOptionsStep, StandardIndexFieldTypeOptionsStep.class);
        }
    }
}

