/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.bridge.mapping.impl;

import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.hibernate.search.engine.cfg.spi.ConvertUtils;
import org.hibernate.search.engine.cfg.spi.ParseUtils;
import org.hibernate.search.engine.spatial.GeoPoint;
import org.hibernate.search.mapper.pojo.bridge.IdentifierBridge;
import org.hibernate.search.mapper.pojo.bridge.ValueBridge;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.DefaultBigIntegerIdentifierBridge;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.DefaultCharacterValueBridge;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.DefaultDurationValueBridge;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.DefaultEnumIdentifierBridge;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.DefaultEnumValueBridge;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.DefaultIntegerIdentifierBridge;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.DefaultJavaNetURIValueBridge;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.DefaultJavaNetURLValueBridge;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.DefaultJavaSqlDateValueBridge;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.DefaultJavaSqlTimeValueBridge;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.DefaultJavaSqlTimestampValueBridge;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.DefaultJavaUtilCalendarValueBridge;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.DefaultJavaUtilDateValueBridge;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.DefaultLongIdentifierBridge;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.DefaultPeriodValueBridge;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.DefaultShortIdentifierBridge;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.DefaultStringIdentifierBridge;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.DefaultUUIDIdentifierBridge;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.DefaultUUIDValueBridge;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.DefaultZoneIdValueBridge;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.DefaultZoneOffsetValueBridge;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.PassThroughValueBridge;
import org.hibernate.search.mapper.pojo.bridge.mapping.programmatic.IdentifierBinder;
import org.hibernate.search.mapper.pojo.bridge.mapping.programmatic.ValueBinder;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.mapper.pojo.model.spi.PojoGenericTypeModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeIdentifier;
import org.hibernate.search.mapper.pojo.model.typepattern.impl.TypePatternMatcher;
import org.hibernate.search.mapper.pojo.model.typepattern.impl.TypePatternMatcherFactory;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public final class BridgeResolver {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final Map<PojoRawTypeIdentifier<?>, IdentifierBinder> exactRawTypeIdentifierBridgeMappings = new HashMap();
    private final Map<PojoRawTypeIdentifier<?>, ValueBinder> exactRawTypeValueBridgeMappings = new HashMap();
    private final List<TypePatternBinderMapping<IdentifierBinder>> typePatternIdentifierBridgeMappings = new ArrayList<TypePatternBinderMapping<IdentifierBinder>>();
    private final List<TypePatternBinderMapping<ValueBinder>> typePatternValueBridgeMappings = new ArrayList<TypePatternBinderMapping<ValueBinder>>();

    public BridgeResolver(TypePatternMatcherFactory typePatternMatcherFactory) {
        TypePatternMatcher concreteEnumPattern = typePatternMatcherFactory.createRawSuperTypeMatcher(Enum.class).and(typePatternMatcherFactory.createExactRawTypeMatcher(Enum.class).negate());
        TypePatternMatcher concreteGeoPointPattern = typePatternMatcherFactory.createRawSuperTypeMatcher(GeoPoint.class);
        this.addIdentifierBridgeForExactRawType(String.class, new DefaultStringIdentifierBridge());
        this.addIdentifierBridgeForExactRawType(Integer.class, new DefaultIntegerIdentifierBridge());
        this.addIdentifierBridgeForExactRawType(Long.class, new DefaultLongIdentifierBridge());
        this.addIdentifierBinderForTypePattern(concreteEnumPattern, new DefaultEnumIdentifierBridge.Binder());
        this.addIdentifierBridgeForExactRawType(Short.class, new DefaultShortIdentifierBridge());
        this.addIdentifierBridgeForExactRawType(BigInteger.class, new DefaultBigIntegerIdentifierBridge());
        this.addIdentifierBridgeForExactRawType(UUID.class, new DefaultUUIDIdentifierBridge());
        this.addValueBinderForExactRawType(Integer.class, new PassThroughValueBridge.Binder<Integer>(Integer.class, ConvertUtils::convertInteger));
        this.addValueBinderForExactRawType(Long.class, new PassThroughValueBridge.Binder<Long>(Long.class, ConvertUtils::convertLong));
        this.addValueBinderForExactRawType(Boolean.class, new PassThroughValueBridge.Binder<Boolean>(Boolean.class, ConvertUtils::convertBoolean));
        this.addValueBinderForExactRawType(String.class, new PassThroughValueBridge.Binder<String>(String.class, ParseUtils::parseString));
        this.addValueBinderForExactRawType(LocalDate.class, new PassThroughValueBridge.Binder<LocalDate>(LocalDate.class, ParseUtils::parseLocalDate));
        this.addValueBinderForExactRawType(Instant.class, new PassThroughValueBridge.Binder<Instant>(Instant.class, ParseUtils::parseInstant));
        this.addValueBridgeForExactRawType(java.util.Date.class, new DefaultJavaUtilDateValueBridge());
        this.addValueBridgeForExactRawType(Calendar.class, new DefaultJavaUtilCalendarValueBridge());
        this.addValueBinderForTypePattern(concreteEnumPattern, new DefaultEnumValueBridge.Binder());
        this.addValueBridgeForExactRawType(Character.class, new DefaultCharacterValueBridge());
        this.addValueBinderForExactRawType(Byte.class, new PassThroughValueBridge.Binder<Byte>(Byte.class, ConvertUtils::convertByte));
        this.addValueBinderForExactRawType(Short.class, new PassThroughValueBridge.Binder<Short>(Short.class, ConvertUtils::convertShort));
        this.addValueBinderForExactRawType(Float.class, new PassThroughValueBridge.Binder<Float>(Float.class, ConvertUtils::convertFloat));
        this.addValueBinderForExactRawType(Double.class, new PassThroughValueBridge.Binder<Double>(Double.class, ConvertUtils::convertDouble));
        this.addValueBinderForExactRawType(BigDecimal.class, new PassThroughValueBridge.Binder<BigDecimal>(BigDecimal.class, ConvertUtils::convertBigDecimal));
        this.addValueBinderForExactRawType(BigInteger.class, new PassThroughValueBridge.Binder<BigInteger>(BigInteger.class, ConvertUtils::convertBigInteger));
        this.addValueBridgeForExactRawType(UUID.class, new DefaultUUIDValueBridge());
        this.addValueBinderForExactRawType(LocalDateTime.class, new PassThroughValueBridge.Binder<LocalDateTime>(LocalDateTime.class, ParseUtils::parseLocalDateTime));
        this.addValueBinderForExactRawType(LocalTime.class, new PassThroughValueBridge.Binder<LocalTime>(LocalTime.class, ParseUtils::parseLocalTime));
        this.addValueBinderForExactRawType(ZonedDateTime.class, new PassThroughValueBridge.Binder<ZonedDateTime>(ZonedDateTime.class, ParseUtils::parseZonedDateTime));
        this.addValueBinderForExactRawType(Year.class, new PassThroughValueBridge.Binder<Year>(Year.class, ParseUtils::parseYear));
        this.addValueBinderForExactRawType(YearMonth.class, new PassThroughValueBridge.Binder<YearMonth>(YearMonth.class, ParseUtils::parseYearMonth));
        this.addValueBinderForExactRawType(MonthDay.class, new PassThroughValueBridge.Binder<MonthDay>(MonthDay.class, ParseUtils::parseMonthDay));
        this.addValueBinderForExactRawType(OffsetDateTime.class, new PassThroughValueBridge.Binder<OffsetDateTime>(OffsetDateTime.class, ParseUtils::parseOffsetDateTime));
        this.addValueBinderForExactRawType(OffsetTime.class, new PassThroughValueBridge.Binder<OffsetTime>(OffsetTime.class, ParseUtils::parseOffsetTime));
        this.addValueBridgeForExactRawType(ZoneOffset.class, new DefaultZoneOffsetValueBridge());
        this.addValueBridgeForExactRawType(ZoneId.class, new DefaultZoneIdValueBridge());
        this.addValueBridgeForExactRawType(Period.class, new DefaultPeriodValueBridge());
        this.addValueBridgeForExactRawType(Duration.class, new DefaultDurationValueBridge());
        this.addValueBridgeForExactRawType(URI.class, new DefaultJavaNetURIValueBridge());
        this.addValueBridgeForExactRawType(URL.class, new DefaultJavaNetURLValueBridge());
        this.addValueBridgeForExactRawType(Date.class, new DefaultJavaSqlDateValueBridge());
        this.addValueBridgeForExactRawType(Timestamp.class, new DefaultJavaSqlTimestampValueBridge());
        this.addValueBridgeForExactRawType(Time.class, new DefaultJavaSqlTimeValueBridge());
        this.addValueBinderForTypePattern(concreteGeoPointPattern, new PassThroughValueBridge.Binder<GeoPoint>(GeoPoint.class, ParseUtils::parseGeoPoint));
    }

    public IdentifierBinder resolveIdentifierBinderForType(PojoGenericTypeModel<?> sourceType) {
        IdentifierBinder result = BridgeResolver.getBinderOrNull(sourceType, this.exactRawTypeIdentifierBridgeMappings, this.typePatternIdentifierBridgeMappings);
        if (result == null) {
            throw log.unableToResolveDefaultIdentifierBridgeFromSourceType(sourceType);
        }
        return result;
    }

    public ValueBinder resolveValueBinderForType(PojoGenericTypeModel<?> sourceType) {
        ValueBinder result = BridgeResolver.getBinderOrNull(sourceType, this.exactRawTypeValueBridgeMappings, this.typePatternValueBridgeMappings);
        if (result == null) {
            throw log.unableToResolveDefaultValueBridgeFromSourceType(sourceType);
        }
        return result;
    }

    private <I> void addIdentifierBinderForExactRawType(Class<I> type, IdentifierBinder binder) {
        this.exactRawTypeIdentifierBridgeMappings.put(PojoRawTypeIdentifier.of(type), binder);
    }

    private <I> void addIdentifierBridgeForExactRawType(Class<I> type, IdentifierBridge<I> bridge) {
        this.addIdentifierBinderForExactRawType(type, context -> context.setBridge(type, bridge));
    }

    private void addIdentifierBinderForTypePattern(TypePatternMatcher typePatternMatcher, IdentifierBinder binder) {
        this.typePatternIdentifierBridgeMappings.add(new TypePatternBinderMapping<IdentifierBinder>(typePatternMatcher, binder));
    }

    private <V> void addValueBinderForExactRawType(Class<V> type, ValueBinder binder) {
        this.exactRawTypeValueBridgeMappings.put(PojoRawTypeIdentifier.of(type), binder);
    }

    private <V> void addValueBridgeForExactRawType(Class<V> type, ValueBridge<V, ?> bridge) {
        this.addValueBinderForExactRawType(type, context -> context.setBridge(type, bridge));
    }

    private void addValueBinderForTypePattern(TypePatternMatcher typePatternMatcher, ValueBinder binder) {
        this.typePatternValueBridgeMappings.add(new TypePatternBinderMapping<ValueBinder>(typePatternMatcher, binder));
    }

    private static <B> B getBinderOrNull(PojoGenericTypeModel<?> sourceType, Map<PojoRawTypeIdentifier<?>, B> exactRawTypeBridgeMappings, List<TypePatternBinderMapping<B>> typePatternBinderMappings) {
        PojoRawTypeIdentifier rawType = sourceType.getRawType().getTypeIdentifier();
        B result = exactRawTypeBridgeMappings.get(rawType);
        if (result == null) {
            Iterator<TypePatternBinderMapping<B>> mappingIterator = typePatternBinderMappings.iterator();
            while (result == null && mappingIterator.hasNext()) {
                result = mappingIterator.next().getBinderIfMatching(sourceType);
            }
        }
        return result;
    }

    private static final class TypePatternBinderMapping<B> {
        private final TypePatternMatcher matcher;
        private final B binder;

        TypePatternBinderMapping(TypePatternMatcher matcher, B binder) {
            this.matcher = matcher;
            this.binder = binder;
        }

        B getBinderIfMatching(PojoGenericTypeModel<?> typeModel) {
            if (this.matcher.matches(typeModel)) {
                return this.binder;
            }
            return null;
        }
    }
}

