/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.bridge.runtime.impl;

import java.util.Optional;
import org.hibernate.search.engine.backend.mapping.spi.BackendMappingContext;
import org.hibernate.search.engine.backend.types.converter.runtime.spi.ToDocumentIdentifierValueConvertContext;
import org.hibernate.search.engine.backend.types.converter.runtime.spi.ToDocumentIdentifierValueConvertContextExtension;
import org.hibernate.search.engine.backend.types.converter.spi.ToDocumentIdentifierValueConverter;
import org.hibernate.search.mapper.pojo.bridge.IdentifierBridge;
import org.hibernate.search.mapper.pojo.bridge.runtime.IdentifierBridgeToDocumentIdentifierContext;
import org.hibernate.search.mapper.pojo.bridge.runtime.spi.BridgeMappingContext;

public final class PojoIdentifierBridgeToDocumentIdentifierValueConverter<I>
implements ToDocumentIdentifierValueConverter<I> {
    private final IdentifierBridge<I> bridge;
    private final Class<I> expectedValueType;

    public PojoIdentifierBridgeToDocumentIdentifierValueConverter(IdentifierBridge<I> bridge, Class<I> expectedValueType) {
        this.bridge = bridge;
        this.expectedValueType = expectedValueType;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[bridge=" + this.bridge + ",expectedValueType=" + this.expectedValueType + "]";
    }

    public String convert(I value, ToDocumentIdentifierValueConvertContext context) {
        IdentifierBridgeToDocumentIdentifierContext extension = (IdentifierBridgeToDocumentIdentifierContext)context.extension((ToDocumentIdentifierValueConvertContextExtension)PojoIdentifierBridgeContextExtension.INSTANCE);
        return this.bridge.toDocumentIdentifier(value, extension);
    }

    public String convertUnknown(Object value, ToDocumentIdentifierValueConvertContext context) {
        return this.convert(this.expectedValueType.cast(value), context);
    }

    public boolean isCompatibleWith(ToDocumentIdentifierValueConverter<?> other) {
        if (other == null || !this.getClass().equals(other.getClass())) {
            return false;
        }
        PojoIdentifierBridgeToDocumentIdentifierValueConverter castedOther = (PojoIdentifierBridgeToDocumentIdentifierValueConverter)other;
        return this.expectedValueType.equals(castedOther.expectedValueType) && this.bridge.isCompatibleWith(castedOther.bridge);
    }

    private static class PojoIdentifierBridgeContextExtension
    implements ToDocumentIdentifierValueConvertContextExtension<IdentifierBridgeToDocumentIdentifierContext> {
        private static final PojoIdentifierBridgeContextExtension INSTANCE = new PojoIdentifierBridgeContextExtension();

        private PojoIdentifierBridgeContextExtension() {
        }

        public Optional<IdentifierBridgeToDocumentIdentifierContext> extendOptional(ToDocumentIdentifierValueConvertContext original, BackendMappingContext mappingContext) {
            if (mappingContext instanceof BridgeMappingContext) {
                BridgeMappingContext pojoMappingContext = (BridgeMappingContext)mappingContext;
                return Optional.of(pojoMappingContext.getIdentifierBridgeToDocumentIdentifierContext());
            }
            return Optional.empty();
        }
    }
}

