/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.model.additionalmetadata.building.impl;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.hibernate.search.engine.environment.bean.BeanResolver;
import org.hibernate.search.engine.reporting.spi.ContextualFailureCollector;
import org.hibernate.search.engine.reporting.spi.FailureCollector;
import org.hibernate.search.mapper.pojo.bridge.binding.impl.MarkerBindingContextImpl;
import org.hibernate.search.mapper.pojo.bridge.mapping.programmatic.MarkerBinder;
import org.hibernate.search.mapper.pojo.model.additionalmetadata.building.impl.PojoEntityTypeAdditionalMetadataBuilder;
import org.hibernate.search.mapper.pojo.model.additionalmetadata.building.impl.PojoIndexedTypeAdditionalMetadataBuilder;
import org.hibernate.search.mapper.pojo.model.additionalmetadata.building.impl.PojoPropertyAdditionalMetadataBuilder;
import org.hibernate.search.mapper.pojo.model.additionalmetadata.building.spi.PojoAdditionalMetadataCollectorPropertyNode;
import org.hibernate.search.mapper.pojo.model.additionalmetadata.building.spi.PojoAdditionalMetadataCollectorTypeNode;
import org.hibernate.search.mapper.pojo.model.additionalmetadata.impl.PojoPropertyAdditionalMetadata;
import org.hibernate.search.mapper.pojo.model.additionalmetadata.impl.PojoTypeAdditionalMetadata;
import org.hibernate.search.mapper.pojo.model.path.spi.PojoPathFilterFactory;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeIdentifier;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.mapper.pojo.reporting.impl.PojoEventContexts;

class PojoTypeAdditionalMetadataBuilder
implements PojoAdditionalMetadataCollectorTypeNode {
    private final BeanResolver beanResolver;
    private final FailureCollector failureCollector;
    private final PojoRawTypeModel<?> rawTypeModel;
    private PojoEntityTypeAdditionalMetadataBuilder entityTypeMetadataBuilder;
    private PojoIndexedTypeAdditionalMetadataBuilder indexedTypeMetadataBuilder;
    private final Map<String, PojoPropertyAdditionalMetadataBuilder> propertyBuilders = new LinkedHashMap<String, PojoPropertyAdditionalMetadataBuilder>();

    PojoTypeAdditionalMetadataBuilder(BeanResolver beanResolver, FailureCollector failureCollector, PojoRawTypeModel<?> rawTypeModel) {
        this.beanResolver = beanResolver;
        this.failureCollector = failureCollector;
        this.rawTypeModel = rawTypeModel;
    }

    @Override
    public ContextualFailureCollector getFailureCollector() {
        return this.failureCollector.withContext(PojoEventContexts.fromType(this.rawTypeModel));
    }

    @Override
    public PojoRawTypeIdentifier<?> getTypeIdentifier() {
        return this.rawTypeModel.getTypeIdentifier();
    }

    @Override
    public PojoEntityTypeAdditionalMetadataBuilder markAsEntity(String entityName, PojoPathFilterFactory<Set<String>> pathFilterFactory) {
        if (this.entityTypeMetadataBuilder == null) {
            this.entityTypeMetadataBuilder = new PojoEntityTypeAdditionalMetadataBuilder(this, entityName, pathFilterFactory);
        } else {
            this.entityTypeMetadataBuilder.checkSameEntity(entityName);
        }
        return this.entityTypeMetadataBuilder;
    }

    @Override
    public PojoIndexedTypeAdditionalMetadataBuilder markAsIndexed(Optional<String> backendName, Optional<String> indexName) {
        if (this.indexedTypeMetadataBuilder == null) {
            this.indexedTypeMetadataBuilder = new PojoIndexedTypeAdditionalMetadataBuilder(this, backendName, indexName);
        } else {
            this.indexedTypeMetadataBuilder.checkSameIndex(backendName, indexName);
        }
        return this.indexedTypeMetadataBuilder;
    }

    @Override
    public PojoAdditionalMetadataCollectorPropertyNode property(String propertyName) {
        return this.propertyBuilders.computeIfAbsent(propertyName, ignored -> new PojoPropertyAdditionalMetadataBuilder(this, propertyName));
    }

    Object bindMarker(MarkerBinder binder) {
        MarkerBindingContextImpl bindingContext = new MarkerBindingContextImpl(this.beanResolver);
        return bindingContext.applyBinder(binder);
    }

    public PojoTypeAdditionalMetadata build() {
        HashMap<String, PojoPropertyAdditionalMetadata> properties = new HashMap<String, PojoPropertyAdditionalMetadata>();
        for (Map.Entry<String, PojoPropertyAdditionalMetadataBuilder> entry : this.propertyBuilders.entrySet()) {
            properties.put(entry.getKey(), entry.getValue().build());
        }
        return new PojoTypeAdditionalMetadata(this.entityTypeMetadataBuilder == null ? Optional.empty() : Optional.of(this.entityTypeMetadataBuilder.build()), this.indexedTypeMetadataBuilder == null ? Optional.empty() : Optional.of(this.indexedTypeMetadataBuilder.build()), properties);
    }
}

