/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.mapping.spi;

import java.util.concurrent.CompletableFuture;
import org.hibernate.search.engine.backend.work.execution.DocumentCommitStrategy;
import org.hibernate.search.engine.backend.work.execution.DocumentRefreshStrategy;
import org.hibernate.search.engine.mapper.mapping.spi.MappingImplementor;
import org.hibernate.search.engine.mapper.mapping.spi.MappingPreStopContext;
import org.hibernate.search.engine.mapper.mapping.spi.MappingStartContext;
import org.hibernate.search.mapper.pojo.bridge.runtime.IdentifierBridgeToDocumentIdentifierContext;
import org.hibernate.search.mapper.pojo.bridge.runtime.ValueBridgeToIndexedValueContext;
import org.hibernate.search.mapper.pojo.bridge.runtime.impl.IdentifierBridgeToDocumentIdentifierContextImpl;
import org.hibernate.search.mapper.pojo.bridge.runtime.impl.ValueBridgeToIndexedValueContextImpl;
import org.hibernate.search.mapper.pojo.mapping.spi.PojoMappingDelegate;
import org.hibernate.search.mapper.pojo.scope.spi.PojoScopeMappingContext;
import org.hibernate.search.mapper.pojo.session.spi.PojoSearchSessionMappingContext;
import org.hibernate.search.mapper.pojo.work.spi.PojoIndexer;
import org.hibernate.search.mapper.pojo.work.spi.PojoIndexingPlan;
import org.hibernate.search.mapper.pojo.work.spi.PojoWorkSessionContext;
import org.hibernate.search.util.common.impl.Closer;

public abstract class AbstractPojoMappingImplementor<M>
implements MappingImplementor<M>,
PojoScopeMappingContext,
PojoSearchSessionMappingContext {
    private final PojoMappingDelegate delegate;
    private boolean stopped = false;
    private final IdentifierBridgeToDocumentIdentifierContext toDocumentIdentifierContext;
    private final ValueBridgeToIndexedValueContext toIndexedValueContext;

    public AbstractPojoMappingImplementor(PojoMappingDelegate delegate) {
        this.delegate = delegate;
        this.toDocumentIdentifierContext = new IdentifierBridgeToDocumentIdentifierContextImpl(this);
        this.toIndexedValueContext = new ValueBridgeToIndexedValueContextImpl(this);
    }

    public CompletableFuture<?> start(MappingStartContext context) {
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<?> preStop(MappingPreStopContext context) {
        return CompletableFuture.completedFuture(null);
    }

    public void stop() {
        if (!this.stopped) {
            this.stopped = true;
            try (Closer closer = new Closer();){
                closer.push(PojoMappingDelegate::close, (Object)this.delegate);
                closer.push(AbstractPojoMappingImplementor::doStop, (Object)this);
            }
        }
    }

    @Override
    public final IdentifierBridgeToDocumentIdentifierContext getIdentifierBridgeToDocumentIdentifierContext() {
        return this.toDocumentIdentifierContext;
    }

    @Override
    public ValueBridgeToIndexedValueContext getValueBridgeToIndexedValueContext() {
        return this.toIndexedValueContext;
    }

    @Override
    public <R> PojoIndexingPlan<R> createIndexingPlan(PojoWorkSessionContext<R> context, DocumentCommitStrategy commitStrategy, DocumentRefreshStrategy refreshStrategy) {
        return this.delegate.createIndexingPlan(context, commitStrategy, refreshStrategy);
    }

    @Override
    public PojoIndexer createIndexer(PojoWorkSessionContext<?> context) {
        return this.delegate.createIndexer(context);
    }

    protected final PojoMappingDelegate getDelegate() {
        return this.delegate;
    }

    protected void doStop() {
    }
}

