/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.automaticindexing.building.impl;

import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import org.hibernate.search.mapper.pojo.automaticindexing.building.impl.AbstractPojoImplicitReindexingResolverTypeNodeBuilder;
import org.hibernate.search.mapper.pojo.automaticindexing.building.impl.PojoImplicitReindexingResolverBuildingHelper;
import org.hibernate.search.mapper.pojo.automaticindexing.building.impl.PojoImplicitReindexingResolverOriginalTypeNodeBuilder;
import org.hibernate.search.mapper.pojo.automaticindexing.building.impl.PojoImplicitReindexingResolverPropertyNodeBuilder;
import org.hibernate.search.mapper.pojo.automaticindexing.building.impl.PojoImplicitReindexingResolverValueNodeBuilderDelegate;
import org.hibernate.search.mapper.pojo.automaticindexing.impl.DefaultPojoImplicitReindexingResolver;
import org.hibernate.search.mapper.pojo.automaticindexing.impl.PojoImplicitReindexingResolver;
import org.hibernate.search.mapper.pojo.automaticindexing.impl.PojoImplicitReindexingResolverNode;
import org.hibernate.search.mapper.pojo.extractor.mapping.programmatic.ContainerExtractorPath;
import org.hibernate.search.mapper.pojo.model.path.PojoModelPathValueNode;
import org.hibernate.search.mapper.pojo.model.path.binding.impl.PojoModelPathWalker;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPath;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPathValueNode;
import org.hibernate.search.mapper.pojo.model.path.spi.PojoPathFilter;
import org.hibernate.search.mapper.pojo.model.path.spi.PojoPathFilterFactory;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.util.common.AssertionFailure;

class PojoImplicitReindexingResolverBuilder<T> {
    private final PojoRawTypeModel<T> rawTypeModel;
    private final Set<PojoModelPathValueNode> dirtyPathsTriggeringSelfReindexing = new LinkedHashSet<PojoModelPathValueNode>();
    private final PojoImplicitReindexingResolverOriginalTypeNodeBuilder<T> containingEntitiesResolverRootBuilder;
    private boolean frozen = false;

    static Walker walker() {
        return Walker.INSTANCE;
    }

    PojoImplicitReindexingResolverBuilder(PojoRawTypeModel<T> rawTypeModel, PojoImplicitReindexingResolverBuildingHelper buildingHelper) {
        this.rawTypeModel = rawTypeModel;
        this.containingEntitiesResolverRootBuilder = new PojoImplicitReindexingResolverOriginalTypeNodeBuilder<T>(BoundPojoModelPath.root(rawTypeModel), buildingHelper);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.rawTypeModel + "]";
    }

    void closeOnFailure() {
        this.containingEntitiesResolverRootBuilder.closeOnFailure();
    }

    void addDirtyPathTriggeringSelfReindexing(BoundPojoModelPathValueNode<?, ?, ?> dirtyPathFromEntityType) {
        this.checkNotFrozen();
        this.dirtyPathsTriggeringSelfReindexing.add(dirtyPathFromEntityType.toUnboundPath());
    }

    PojoImplicitReindexingResolverOriginalTypeNodeBuilder<T> containingEntitiesResolverRoot() {
        return this.containingEntitiesResolverRootBuilder;
    }

    final <S> Optional<PojoImplicitReindexingResolver<T, S>> build(PojoPathFilterFactory<S> pathFilterFactory) {
        this.freeze();
        Set<PojoModelPathValueNode> immutableDirtyPathsAcceptedByFilter = this.dirtyPathsTriggeringSelfReindexing;
        Optional<PojoImplicitReindexingResolverNode<PojoImplicitReindexingResolverNode, S>> containingEntitiesResolverRootOptional = this.containingEntitiesResolverRootBuilder.build(pathFilterFactory, null);
        if (immutableDirtyPathsAcceptedByFilter.isEmpty() && !containingEntitiesResolverRootOptional.isPresent()) {
            return Optional.empty();
        }
        PojoPathFilter filter = immutableDirtyPathsAcceptedByFilter.isEmpty() ? PojoPathFilter.empty() : pathFilterFactory.create(immutableDirtyPathsAcceptedByFilter);
        PojoImplicitReindexingResolverNode containingEntitiesResolverRoot = containingEntitiesResolverRootOptional.orElseGet(PojoImplicitReindexingResolverNode::noOp);
        return Optional.of(new DefaultPojoImplicitReindexingResolver(filter, containingEntitiesResolverRoot));
    }

    private void freeze() {
        if (!this.frozen) {
            this.frozen = true;
            this.containingEntitiesResolverRootBuilder.freeze();
        }
    }

    private void checkNotFrozen() {
        if (this.frozen) {
            throw new AssertionFailure("A mutating method was called on " + this + " after it was frozen. There is a bug in Hibernate Search, please report it.");
        }
    }

    static class Walker
    implements PojoModelPathWalker<AbstractPojoImplicitReindexingResolverTypeNodeBuilder<?, ?>, PojoImplicitReindexingResolverPropertyNodeBuilder<?, ?>, PojoImplicitReindexingResolverValueNodeBuilderDelegate<?>> {
        public static final Walker INSTANCE = new Walker();

        Walker() {
        }

        @Override
        public PojoImplicitReindexingResolverPropertyNodeBuilder<?, ?> property(AbstractPojoImplicitReindexingResolverTypeNodeBuilder<?, ?> typeNode, String propertyName) {
            return typeNode.property(propertyName);
        }

        @Override
        public PojoImplicitReindexingResolverValueNodeBuilderDelegate<?> value(PojoImplicitReindexingResolverPropertyNodeBuilder<?, ?> propertyNode, ContainerExtractorPath extractorPath) {
            return propertyNode.value(extractorPath);
        }

        @Override
        public AbstractPojoImplicitReindexingResolverTypeNodeBuilder<?, ?> type(PojoImplicitReindexingResolverValueNodeBuilderDelegate<?> valueNode) {
            return valueNode.type();
        }
    }
}

