/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.work.impl;

import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.hibernate.search.engine.backend.work.execution.spi.DocumentReferenceProvider;
import org.hibernate.search.engine.backend.work.execution.spi.IndexIndexer;
import org.hibernate.search.mapper.pojo.work.impl.PojoWorkIndexedTypeContext;
import org.hibernate.search.mapper.pojo.work.spi.PojoWorkSessionContext;

public class PojoTypeIndexer<I, E> {
    private final PojoWorkSessionContext<?> sessionContext;
    private final PojoWorkIndexedTypeContext<I, E> typeContext;
    private final IndexIndexer delegate;

    public PojoTypeIndexer(PojoWorkIndexedTypeContext<I, E> typeContext, PojoWorkSessionContext<?> sessionContext, IndexIndexer delegate) {
        this.sessionContext = sessionContext;
        this.typeContext = typeContext;
        this.delegate = delegate;
    }

    CompletableFuture<?> add(Object providedId, Object entity) {
        Supplier<E> entitySupplier = this.typeContext.toEntitySupplier(this.sessionContext, entity);
        I identifier = this.typeContext.getIdentifierMapping().getIdentifier(providedId, entitySupplier);
        DocumentReferenceProvider referenceProvider = this.typeContext.toDocumentReferenceProvider(this.sessionContext, identifier, entitySupplier);
        return this.delegate.add(referenceProvider, this.typeContext.toDocumentContributor(entitySupplier, this.sessionContext));
    }
}

