/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.work.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.hibernate.search.engine.backend.work.execution.spi.DocumentReferenceProvider;
import org.hibernate.search.engine.backend.work.execution.spi.IndexIndexingPlan;
import org.hibernate.search.engine.backend.work.execution.spi.IndexIndexingPlanExecutionReport;
import org.hibernate.search.mapper.pojo.automaticindexing.impl.PojoReindexingCollector;
import org.hibernate.search.mapper.pojo.work.impl.AbstractPojoTypeIndexingPlan;
import org.hibernate.search.mapper.pojo.work.impl.PojoWorkIndexedTypeContext;
import org.hibernate.search.mapper.pojo.work.spi.PojoWorkSessionContext;

public class PojoIndexedTypeIndexingPlan<I, E, R>
extends AbstractPojoTypeIndexingPlan {
    private final PojoWorkIndexedTypeContext<I, E> typeContext;
    private final IndexIndexingPlan<R> delegate;
    private final Map<I, IndexedEntityIndexingPlan> indexingPlansPerId = new LinkedHashMap<I, IndexedEntityIndexingPlan>();

    public PojoIndexedTypeIndexingPlan(PojoWorkIndexedTypeContext<I, E> typeContext, PojoWorkSessionContext<?> sessionContext, IndexIndexingPlan<R> delegate) {
        super(sessionContext);
        this.typeContext = typeContext;
        this.delegate = delegate;
    }

    @Override
    void add(Object providedId, Object entity) {
        Supplier<E> entitySupplier = this.typeContext.toEntitySupplier(this.sessionContext, entity);
        I identifier = this.typeContext.getIdentifierMapping().getIdentifier(providedId, entitySupplier);
        this.getPlan(identifier).add(entitySupplier);
    }

    @Override
    void update(Object providedId, Object entity) {
        Supplier<E> entitySupplier = this.typeContext.toEntitySupplier(this.sessionContext, entity);
        I identifier = this.typeContext.getIdentifierMapping().getIdentifier(providedId, entitySupplier);
        this.getPlan(identifier).update(entitySupplier);
    }

    @Override
    void update(Object providedId, Object entity, String ... dirtyPaths) {
        Supplier<E> entitySupplier = this.typeContext.toEntitySupplier(this.sessionContext, entity);
        I identifier = this.typeContext.getIdentifierMapping().getIdentifier(providedId, entitySupplier);
        this.getPlan(identifier).update(entitySupplier, dirtyPaths);
    }

    @Override
    void delete(Object providedId, Object entity) {
        Supplier<E> entitySupplier = this.typeContext.toEntitySupplier(this.sessionContext, entity);
        I identifier = this.typeContext.getIdentifierMapping().getIdentifier(providedId, entitySupplier);
        this.getPlan(identifier).delete(entitySupplier);
    }

    @Override
    void purge(Object providedId, String providedRoutingKey) {
        I identifier = this.typeContext.getIdentifierMapping().getIdentifier(providedId);
        this.getPlan(identifier).purge(providedRoutingKey);
    }

    void updateBecauseOfContained(Object entity) {
        Supplier<E> entitySupplier = this.typeContext.toEntitySupplier(this.sessionContext, entity);
        I identifier = this.typeContext.getIdentifierMapping().getIdentifier(null, entitySupplier);
        if (!this.indexingPlansPerId.containsKey(identifier)) {
            this.getPlan(identifier).updateBecauseOfContained(entitySupplier);
        }
    }

    void resolveDirty(PojoReindexingCollector containingEntityCollector) {
        ArrayList<IndexedEntityIndexingPlan> frozenIndexingPlansPerId = new ArrayList<IndexedEntityIndexingPlan>(this.indexingPlansPerId.values());
        for (IndexedEntityIndexingPlan plan : frozenIndexingPlansPerId) {
            plan.resolveDirty(containingEntityCollector);
        }
    }

    void process() {
        this.sendCommandsToDelegate();
        this.getDelegate().process();
    }

    CompletableFuture<IndexIndexingPlanExecutionReport<R>> executeAndReport() {
        this.sendCommandsToDelegate();
        return this.delegate.executeAndReport();
    }

    void discard() {
        this.delegate.discard();
    }

    void discardNotProcessed() {
        this.indexingPlansPerId.clear();
    }

    private IndexedEntityIndexingPlan getPlan(I identifier) {
        IndexedEntityIndexingPlan plan = this.indexingPlansPerId.get(identifier);
        if (plan == null) {
            plan = new IndexedEntityIndexingPlan(identifier);
            this.indexingPlansPerId.put(identifier, plan);
        }
        return plan;
    }

    private IndexIndexingPlan<?> getDelegate() {
        return this.delegate;
    }

    private void sendCommandsToDelegate() {
        try {
            this.indexingPlansPerId.values().forEach(IndexedEntityIndexingPlan::sendCommandsToDelegate);
        }
        finally {
            this.indexingPlansPerId.clear();
        }
    }

    private class IndexedEntityIndexingPlan {
        private final I identifier;
        private String providedRoutingKey;
        private Supplier<E> entitySupplier;
        private boolean delete;
        private boolean add;
        private boolean shouldResolveToReindex;
        private boolean considerAllDirty;
        private boolean updatedBecauseOfContained;
        private Set<String> dirtyPaths;

        private IndexedEntityIndexingPlan(I identifier) {
            this.identifier = identifier;
        }

        void add(Supplier<E> entitySupplier) {
            this.entitySupplier = entitySupplier;
            this.providedRoutingKey = null;
            this.shouldResolveToReindex = true;
            this.add = true;
        }

        void update(Supplier<E> entitySupplier) {
            this.doUpdate(entitySupplier);
            this.shouldResolveToReindex = true;
            this.considerAllDirty = true;
            this.dirtyPaths = null;
        }

        void update(Supplier<E> entitySupplier, String ... dirtyPaths) {
            this.doUpdate(entitySupplier);
            this.shouldResolveToReindex = true;
            if (!this.considerAllDirty) {
                for (String dirtyPropertyName : dirtyPaths) {
                    this.addDirtyPath(dirtyPropertyName);
                }
            }
        }

        void updateBecauseOfContained(Supplier<E> entitySupplier) {
            this.doUpdate(entitySupplier);
            this.updatedBecauseOfContained = true;
        }

        void delete(Supplier<E> entitySupplier) {
            this.entitySupplier = entitySupplier;
            this.providedRoutingKey = null;
            if (this.add && !this.delete) {
                this.shouldResolveToReindex = false;
                this.considerAllDirty = false;
                this.updatedBecauseOfContained = false;
                this.dirtyPaths = null;
                this.add = false;
                this.delete = false;
            } else {
                this.add = false;
                this.delete = true;
            }
        }

        void purge(String providedRoutingKey) {
            this.entitySupplier = null;
            this.providedRoutingKey = providedRoutingKey;
            this.shouldResolveToReindex = false;
            this.considerAllDirty = false;
            this.dirtyPaths = null;
            this.add = false;
            this.delete = true;
        }

        void resolveDirty(PojoReindexingCollector containingEntityCollector) {
            if (this.shouldResolveToReindex) {
                this.shouldResolveToReindex = false;
                PojoIndexedTypeIndexingPlan.this.typeContext.resolveEntitiesToReindex(containingEntityCollector, PojoIndexedTypeIndexingPlan.this.sessionContext.getRuntimeIntrospector(), this.entitySupplier, this.considerAllDirty ? null : this.dirtyPaths);
            }
        }

        void sendCommandsToDelegate() {
            if (this.add) {
                if (this.delete) {
                    if (this.considerAllDirty || this.updatedBecauseOfContained || PojoIndexedTypeIndexingPlan.this.typeContext.requiresSelfReindexing(this.dirtyPaths)) {
                        PojoIndexedTypeIndexingPlan.this.delegate.update(PojoIndexedTypeIndexingPlan.this.typeContext.toDocumentReferenceProvider(PojoIndexedTypeIndexingPlan.this.sessionContext, this.identifier, this.entitySupplier), PojoIndexedTypeIndexingPlan.this.typeContext.toDocumentContributor(this.entitySupplier, PojoIndexedTypeIndexingPlan.this.sessionContext));
                    }
                } else {
                    PojoIndexedTypeIndexingPlan.this.delegate.add(PojoIndexedTypeIndexingPlan.this.typeContext.toDocumentReferenceProvider(PojoIndexedTypeIndexingPlan.this.sessionContext, this.identifier, this.entitySupplier), PojoIndexedTypeIndexingPlan.this.typeContext.toDocumentContributor(this.entitySupplier, PojoIndexedTypeIndexingPlan.this.sessionContext));
                }
            } else if (this.delete) {
                DocumentReferenceProvider referenceProvider = this.entitySupplier == null ? PojoIndexedTypeIndexingPlan.this.typeContext.toDocumentReferenceProvider(PojoIndexedTypeIndexingPlan.this.sessionContext, this.identifier, this.providedRoutingKey) : PojoIndexedTypeIndexingPlan.this.typeContext.toDocumentReferenceProvider(PojoIndexedTypeIndexingPlan.this.sessionContext, this.identifier, this.entitySupplier);
                PojoIndexedTypeIndexingPlan.this.delegate.delete(referenceProvider);
            }
        }

        private void doUpdate(Supplier<E> entitySupplier) {
            this.entitySupplier = entitySupplier;
            this.providedRoutingKey = null;
            if (!this.add) {
                this.delete = true;
                this.add = true;
            }
        }

        private void addDirtyPath(String dirtyPath) {
            if (this.dirtyPaths == null) {
                this.dirtyPaths = new HashSet<String>();
            }
            this.dirtyPaths.add(dirtyPath);
        }
    }
}

