/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.automaticindexing.impl;

import java.util.stream.Stream;
import org.hibernate.search.mapper.pojo.automaticindexing.impl.PojoImplicitReindexingResolverNode;
import org.hibernate.search.mapper.pojo.automaticindexing.impl.PojoReindexingCollector;
import org.hibernate.search.mapper.pojo.extractor.impl.ContainerExtractorHolder;
import org.hibernate.search.mapper.pojo.model.spi.PojoRuntimeIntrospector;
import org.hibernate.search.util.common.impl.Closer;
import org.hibernate.search.util.common.impl.ToStringTreeBuilder;

public class PojoImplicitReindexingResolverContainerElementNode<C, S, V>
extends PojoImplicitReindexingResolverNode<C, S> {
    private final ContainerExtractorHolder<C, V> extractorHolder;
    private final PojoImplicitReindexingResolverNode<? super V, S> nested;

    public PojoImplicitReindexingResolverContainerElementNode(ContainerExtractorHolder<C, V> extractorHolder, PojoImplicitReindexingResolverNode<? super V, S> nested) {
        this.extractorHolder = extractorHolder;
        this.nested = nested;
    }

    @Override
    public void close() {
        try (Closer closer = new Closer();){
            closer.push(ContainerExtractorHolder::close, this.extractorHolder);
            closer.pushAll(PojoImplicitReindexingResolverNode::close, (Object[])new PojoImplicitReindexingResolverNode[]{this.nested});
        }
    }

    public void appendTo(ToStringTreeBuilder builder) {
        builder.attribute("operation", (Object)"process container element");
        builder.attribute("extractor", this.extractorHolder.get());
        builder.attribute("nested", this.nested);
    }

    @Override
    public void resolveEntitiesToReindex(PojoReindexingCollector collector, PojoRuntimeIntrospector runtimeIntrospector, C dirty, S dirtinessState) {
        try (Stream<V> stream = this.extractorHolder.get().extract(dirty);){
            stream.forEach(containerElement -> this.resolveEntitiesToReindexForContainerElement(collector, runtimeIntrospector, containerElement, dirtinessState));
        }
    }

    private void resolveEntitiesToReindexForContainerElement(PojoReindexingCollector collector, PojoRuntimeIntrospector runtimeIntrospector, V containerElement, S dirtinessState) {
        if (containerElement != null) {
            this.nested.resolveEntitiesToReindex(collector, runtimeIntrospector, containerElement, dirtinessState);
        }
    }
}

