/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.extractor.mapping.programmatic;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

public class ContainerExtractorPath {
    private static final ContainerExtractorPath DEFAULT = new ContainerExtractorPath(true, Collections.emptyList());
    private static final ContainerExtractorPath NONE = new ContainerExtractorPath(false, Collections.emptyList());
    private final boolean applyDefaultExtractors;
    private final List<String> explicitExtractorNames;

    public static ContainerExtractorPath defaultExtractors() {
        return DEFAULT;
    }

    public static ContainerExtractorPath noExtractors() {
        return NONE;
    }

    public static ContainerExtractorPath explicitExtractor(String extractorName) {
        return new ContainerExtractorPath(false, Collections.singletonList(extractorName));
    }

    public static ContainerExtractorPath explicitExtractors(List<String> extractorNames) {
        if (extractorNames.isEmpty()) {
            return ContainerExtractorPath.noExtractors();
        }
        return new ContainerExtractorPath(false, Collections.unmodifiableList(new ArrayList<String>(extractorNames)));
    }

    private ContainerExtractorPath(boolean applyDefaultExtractors, List<String> explicitExtractorNames) {
        this.applyDefaultExtractors = applyDefaultExtractors;
        this.explicitExtractorNames = explicitExtractorNames;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ContainerExtractorPath)) {
            return false;
        }
        ContainerExtractorPath other = (ContainerExtractorPath)obj;
        return this.applyDefaultExtractors == other.applyDefaultExtractors && Objects.equals(this.explicitExtractorNames, other.explicitExtractorNames);
    }

    public int hashCode() {
        return Objects.hash(this.applyDefaultExtractors, this.explicitExtractorNames);
    }

    public String toString() {
        if (this.isDefault()) {
            return "<default value extractors>";
        }
        if (this.explicitExtractorNames.isEmpty()) {
            return "<no value extractors>";
        }
        StringJoiner joiner = new StringJoiner(", ", "<", ">");
        for (String extractorName : this.explicitExtractorNames) {
            joiner.add(extractorName);
        }
        return joiner.toString();
    }

    public boolean isDefault() {
        return this.applyDefaultExtractors;
    }

    public boolean isEmpty() {
        return !this.isDefault() && this.explicitExtractorNames.isEmpty();
    }

    public List<String> explicitExtractorNames() {
        return this.explicitExtractorNames;
    }

    @Deprecated
    public List<String> getExplicitExtractorNames() {
        return this.explicitExtractorNames();
    }
}

