/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.model.hcann.spi;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.annotations.common.reflection.java.JavaXMember;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class PojoCommonsAnnotationsHelper {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static Method getMemberMethod;

    private PojoCommonsAnnotationsHelper() {
    }

    public static Member extractUnderlyingMember(XProperty xProperty) {
        try {
            return (Member)getMemberMethod.invoke((Object)xProperty, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new AssertionFailure("Could not resolve member signature from XProperty reference", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new AssertionFailure("Could not resolve member signature from XProperty reference", e.getCause());
        }
    }

    public static Method extractUnderlyingMethod(XProperty xProperty) {
        Member member = PojoCommonsAnnotationsHelper.extractUnderlyingMember(xProperty);
        if (!(member instanceof Method)) {
            throw log.cannotAccessPropertyMethod(xProperty.getName());
        }
        return (Method)member;
    }

    static {
        Class<JavaXMember> javaXMemberClass = JavaXMember.class;
        try {
            getMemberMethod = javaXMemberClass.getDeclaredMethod("getMember", new Class[0]);
            getMemberMethod.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new AssertionFailure("Could not resolve JavaXMember#getMember method in order to access XProperty member signature", (Throwable)e);
        }
        catch (Exception e) {
            throw log.cannotAccessPropertyMember(e);
        }
    }
}

