/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.model.impl;

import java.util.stream.Stream;
import org.hibernate.search.mapper.pojo.automaticindexing.building.impl.PojoIndexingDependencyCollectorPropertyNode;
import org.hibernate.search.mapper.pojo.automaticindexing.building.impl.PojoIndexingDependencyCollectorTypeNode;
import org.hibernate.search.mapper.pojo.automaticindexing.building.impl.PojoIndexingDependencyCollectorValueNode;
import org.hibernate.search.mapper.pojo.model.PojoElementAccessor;
import org.hibernate.search.mapper.pojo.model.PojoModelProperty;
import org.hibernate.search.mapper.pojo.model.additionalmetadata.impl.PojoPropertyAdditionalMetadata;
import org.hibernate.search.mapper.pojo.model.impl.AbstractPojoModelCompositeElement;
import org.hibernate.search.mapper.pojo.model.impl.PojoPropertyElementAccessor;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPathPropertyNode;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPathTypeNode;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPathValueNode;
import org.hibernate.search.util.common.reflect.spi.ValueReadHandle;

class PojoModelNestedCompositeElement<T, P>
extends AbstractPojoModelCompositeElement<P>
implements PojoModelProperty {
    private final AbstractPojoModelCompositeElement<T> parent;
    private final BoundPojoModelPathValueNode<T, P, P> modelPath;
    private final PojoPropertyAdditionalMetadata propertyAdditionalMetadata;

    PojoModelNestedCompositeElement(AbstractPojoModelCompositeElement<T> parent, BoundPojoModelPathPropertyNode<T, P> modelPath, PojoPropertyAdditionalMetadata propertyAdditionalMetadata) {
        super(parent);
        this.parent = parent;
        this.modelPath = modelPath.valueWithoutExtractors();
        this.propertyAdditionalMetadata = propertyAdditionalMetadata;
    }

    @Override
    public <M> Stream<M> markers(Class<M> markerType) {
        return this.propertyAdditionalMetadata.getMarkers(markerType);
    }

    @Override
    public String name() {
        return ((BoundPojoModelPathPropertyNode)this.modelPath.getParent()).getPropertyModel().name();
    }

    public void contributeDependencies(PojoIndexingDependencyCollectorTypeNode<T> dependencyCollector) {
        if (this.hasAccessor()) {
            PojoIndexingDependencyCollectorPropertyNode<T, ?> collectorPropertyNode = dependencyCollector.property(this.name());
            PojoIndexingDependencyCollectorValueNode<?, P> collectorValueNode = collectorPropertyNode.value(this.modelPath.getBoundExtractorPath());
            collectorValueNode.collectDependency();
            this.contributePropertyDependencies(collectorValueNode.type());
        }
    }

    @Override
    PojoElementAccessor<P> doCreateAccessor() {
        return new PojoPropertyElementAccessor<P>(this.parent.createAccessor(), this.getHandle(), this.modelPath.toUnboundPath());
    }

    @Override
    BoundPojoModelPathTypeNode<P> getModelPathTypeNode() {
        return this.modelPath.type();
    }

    ValueReadHandle<P> getHandle() {
        return ((BoundPojoModelPathPropertyNode)this.modelPath.getParent()).getValueReadHandle();
    }
}

