/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.work.impl;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import org.hibernate.search.engine.backend.work.execution.DocumentCommitStrategy;
import org.hibernate.search.engine.backend.work.execution.DocumentRefreshStrategy;
import org.hibernate.search.engine.backend.work.execution.spi.DocumentReferenceProvider;
import org.hibernate.search.engine.backend.work.execution.spi.IndexIndexer;
import org.hibernate.search.mapper.pojo.route.impl.DocumentRouteImpl;
import org.hibernate.search.mapper.pojo.work.impl.PojoDocumentReferenceProvider;
import org.hibernate.search.mapper.pojo.work.impl.PojoWorkIndexedTypeContext;
import org.hibernate.search.mapper.pojo.work.impl.PojoWorkRouter;
import org.hibernate.search.mapper.pojo.work.spi.PojoWorkSessionContext;

public class PojoTypeIndexer<I, E> {
    private final PojoWorkSessionContext<?> sessionContext;
    private final PojoWorkIndexedTypeContext<I, E> typeContext;
    private final IndexIndexer delegate;

    public PojoTypeIndexer(PojoWorkIndexedTypeContext<I, E> typeContext, PojoWorkSessionContext<?> sessionContext, IndexIndexer delegate) {
        this.sessionContext = sessionContext;
        this.typeContext = typeContext;
        this.delegate = delegate;
    }

    CompletableFuture<?> add(Object providedId, String providedRoutingKey, Object entity, DocumentCommitStrategy commitStrategy, DocumentRefreshStrategy refreshStrategy) {
        Supplier entitySupplier = this.typeContext.toEntitySupplier(this.sessionContext, entity);
        I identifier = this.typeContext.identifierMapping().getIdentifier(providedId, entitySupplier);
        PojoWorkRouter router = this.typeContext.createRouter(this.sessionContext, identifier, entitySupplier);
        DocumentRouteImpl currentRoute = router.currentRoute(providedRoutingKey);
        if (currentRoute == null) {
            return CompletableFuture.completedFuture(null);
        }
        String documentIdentifier = this.typeContext.toDocumentIdentifier(this.sessionContext, identifier);
        PojoDocumentReferenceProvider referenceProvider = new PojoDocumentReferenceProvider(documentIdentifier, currentRoute.routingKey(), identifier);
        return this.delegate.add((DocumentReferenceProvider)referenceProvider, this.typeContext.toDocumentContributor(this.sessionContext, identifier, entitySupplier), commitStrategy, refreshStrategy);
    }

    CompletableFuture<?> addOrUpdate(Object providedId, String providedRoutingKey, Object entity, DocumentCommitStrategy commitStrategy, DocumentRefreshStrategy refreshStrategy) {
        Supplier entitySupplier = this.typeContext.toEntitySupplier(this.sessionContext, entity);
        I identifier = this.typeContext.identifierMapping().getIdentifier(providedId, entitySupplier);
        PojoWorkRouter router = this.typeContext.createRouter(this.sessionContext, identifier, entitySupplier);
        DocumentRouteImpl currentRoute = router.currentRoute(providedRoutingKey);
        List<DocumentRouteImpl> previousRoutes = router.previousRoutes(currentRoute);
        String documentIdentifier = this.typeContext.toDocumentIdentifier(this.sessionContext, identifier);
        CompletableFuture<?> deletePreviousFuture = this.deletePrevious(documentIdentifier, previousRoutes, identifier, commitStrategy, refreshStrategy);
        if (currentRoute == null) {
            return deletePreviousFuture;
        }
        PojoDocumentReferenceProvider referenceProvider = new PojoDocumentReferenceProvider(documentIdentifier, currentRoute.routingKey(), identifier);
        return deletePreviousFuture.thenCombine((CompletionStage)this.delegate.update((DocumentReferenceProvider)referenceProvider, this.typeContext.toDocumentContributor(this.sessionContext, identifier, entitySupplier), commitStrategy, refreshStrategy), (deletePreviousResult, updateResult) -> updateResult);
    }

    CompletableFuture<?> delete(Object providedId, String providedRoutingKey, Object entity, DocumentCommitStrategy commitStrategy, DocumentRefreshStrategy refreshStrategy) {
        Supplier entitySupplier = this.typeContext.toEntitySupplier(this.sessionContext, entity);
        I identifier = this.typeContext.identifierMapping().getIdentifier(providedId, entitySupplier);
        PojoWorkRouter router = this.typeContext.createRouter(this.sessionContext, identifier, entitySupplier);
        DocumentRouteImpl currentRoute = router.currentRoute(providedRoutingKey);
        List<DocumentRouteImpl> previousRoutes = router.previousRoutes(currentRoute);
        String documentIdentifier = this.typeContext.toDocumentIdentifier(this.sessionContext, identifier);
        CompletableFuture<?> deletePreviousFuture = this.deletePrevious(documentIdentifier, previousRoutes, identifier, commitStrategy, refreshStrategy);
        if (currentRoute == null) {
            return deletePreviousFuture;
        }
        PojoDocumentReferenceProvider referenceProvider = new PojoDocumentReferenceProvider(documentIdentifier, currentRoute.routingKey(), identifier);
        return deletePreviousFuture.thenCombine((CompletionStage)this.delegate.delete((DocumentReferenceProvider)referenceProvider, commitStrategy, refreshStrategy), (deletePreviousResult, deleteResult) -> deleteResult);
    }

    CompletableFuture<?> purge(Object providedId, String providedRoutingKey, DocumentCommitStrategy commitStrategy, DocumentRefreshStrategy refreshStrategy) {
        I identifier = this.typeContext.identifierMapping().getIdentifier(providedId);
        String documentIdentifier = this.typeContext.toDocumentIdentifier(this.sessionContext, identifier);
        PojoDocumentReferenceProvider referenceProvider = new PojoDocumentReferenceProvider(documentIdentifier, providedRoutingKey, identifier);
        return this.delegate.delete((DocumentReferenceProvider)referenceProvider, commitStrategy, refreshStrategy);
    }

    private CompletableFuture<?> deletePrevious(String documentIdentifier, List<DocumentRouteImpl> previousRoutes, I identifier, DocumentCommitStrategy commitStrategy, DocumentRefreshStrategy refreshStrategy) {
        if (previousRoutes.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        CompletableFuture[] futures = new CompletableFuture[previousRoutes.size()];
        for (int i = 0; i < previousRoutes.size(); ++i) {
            DocumentRouteImpl route = previousRoutes.get(i);
            PojoDocumentReferenceProvider referenceProvider = new PojoDocumentReferenceProvider(documentIdentifier, route.routingKey(), identifier);
            futures[i] = this.delegate.delete((DocumentReferenceProvider)referenceProvider, commitStrategy, refreshStrategy);
        }
        return CompletableFuture.allOf(futures);
    }
}

