/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.mapping.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hibernate.search.mapper.pojo.bridge.RoutingBridge;
import org.hibernate.search.mapper.pojo.bridge.runtime.RoutingBridgeRouteContext;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.mapper.pojo.route.DocumentRoute;
import org.hibernate.search.mapper.pojo.route.DocumentRoutes;
import org.hibernate.search.mapper.pojo.route.impl.DocumentRouteImpl;
import org.hibernate.search.mapper.pojo.work.impl.PojoWorkRouter;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public final class RoutingBridgeDocumentRouter<E>
implements DocumentRoutes,
PojoWorkRouter {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final RoutingBridgeRouteContext context;
    private final RoutingBridge<? super E> routingBridge;
    private final Object entityIdentifier;
    private final E entity;
    private DocumentRouteImpl currentRoute = null;
    private boolean skip = false;

    public RoutingBridgeDocumentRouter(RoutingBridgeRouteContext context, RoutingBridge<? super E> routingBridge, Object entityIdentifier, E entity) {
        this.context = context;
        this.routingBridge = routingBridge;
        this.entityIdentifier = entityIdentifier;
        this.entity = entity;
    }

    @Override
    public DocumentRoute addRoute() {
        if (this.currentRoute != null) {
            throw log.multipleCurrentRoutes(this.routingBridge);
        }
        this.currentRoute = new DocumentRouteImpl();
        return this.currentRoute;
    }

    @Override
    public void notIndexed() {
        this.skip = true;
    }

    @Override
    public DocumentRouteImpl currentRoute(String providedRoutingKey) {
        this.routingBridge.route(this, this.entityIdentifier, this.entity, this.context);
        if (this.skip) {
            return null;
        }
        if (this.currentRoute == null) {
            throw log.noCurrentRoute(this.routingBridge);
        }
        if (providedRoutingKey != null) {
            this.currentRoute.routingKey(providedRoutingKey);
        }
        return this.currentRoute;
    }

    @Override
    public List<DocumentRouteImpl> previousRoutes(DocumentRouteImpl currentRoute) {
        return new PreviousDocumentRoutes().previousDifferentRoutes(currentRoute);
    }

    private final class PreviousDocumentRoutes
    implements DocumentRoutes {
        private List<DocumentRouteImpl> previousRoutes = null;
        private boolean skip = false;

        private PreviousDocumentRoutes() {
        }

        @Override
        public DocumentRoute addRoute() {
            if (this.previousRoutes == null) {
                this.previousRoutes = new ArrayList<DocumentRouteImpl>();
            }
            DocumentRouteImpl route = new DocumentRouteImpl();
            this.previousRoutes.add(route);
            return route;
        }

        @Override
        public void notIndexed() {
            this.skip = true;
        }

        List<DocumentRouteImpl> previousDifferentRoutes(DocumentRouteImpl currentRoute) {
            RoutingBridgeDocumentRouter.this.routingBridge.previousRoutes(this, RoutingBridgeDocumentRouter.this.entityIdentifier, RoutingBridgeDocumentRouter.this.entity, RoutingBridgeDocumentRouter.this.context);
            if (this.skip) {
                return Collections.emptyList();
            }
            if (this.previousRoutes == null || this.previousRoutes.isEmpty()) {
                throw log.noPreviousRoute(RoutingBridgeDocumentRouter.this.routingBridge);
            }
            if (currentRoute != null) {
                this.previousRoutes.remove(currentRoute);
            }
            return this.previousRoutes;
        }
    }
}

