/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.automaticindexing.building.impl;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.hibernate.search.mapper.pojo.automaticindexing.building.impl.AbstractPojoImplicitReindexingResolverNodeBuilder;
import org.hibernate.search.mapper.pojo.automaticindexing.building.impl.PojoImplicitReindexingResolverBuildingHelper;
import org.hibernate.search.mapper.pojo.automaticindexing.building.impl.PojoImplicitReindexingResolverMarkingNodeBuilder;
import org.hibernate.search.mapper.pojo.automaticindexing.building.impl.PojoImplicitReindexingResolverPropertyNodeBuilder;
import org.hibernate.search.mapper.pojo.automaticindexing.impl.PojoImplicitReindexingResolverNode;
import org.hibernate.search.mapper.pojo.model.path.PojoModelPathValueNode;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPathTypeNode;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPathValueNode;
import org.hibernate.search.mapper.pojo.model.path.spi.PojoPathFilterFactory;
import org.hibernate.search.mapper.pojo.model.spi.PojoTypeModel;
import org.hibernate.search.util.common.impl.Closer;

abstract class AbstractPojoImplicitReindexingResolverTypeNodeBuilder<T, U>
extends AbstractPojoImplicitReindexingResolverNodeBuilder<T> {
    private final PojoImplicitReindexingResolverMarkingNodeBuilder<U> markingNodeBuilder;
    private final Map<String, PojoImplicitReindexingResolverPropertyNodeBuilder<U, ?>> propertyNodeBuilders = new LinkedHashMap();

    AbstractPojoImplicitReindexingResolverTypeNodeBuilder(BoundPojoModelPathTypeNode<U> modelPath, PojoImplicitReindexingResolverBuildingHelper buildingHelper) {
        super(buildingHelper);
        this.markingNodeBuilder = new PojoImplicitReindexingResolverMarkingNodeBuilder<U>(modelPath, buildingHelper);
    }

    @Override
    void closeOnFailure() {
        try (Closer closer = new Closer();){
            closer.push(PojoImplicitReindexingResolverMarkingNodeBuilder::closeOnFailure, this.markingNodeBuilder);
            closer.pushAll(AbstractPojoImplicitReindexingResolverNodeBuilder::closeOnFailure, this.propertyNodeBuilders.values());
        }
    }

    @Override
    abstract BoundPojoModelPathTypeNode<U> getModelPath();

    PojoTypeModel<U> getTypeModel() {
        return ((BoundPojoModelPathTypeNode)this.getModelPath()).getTypeModel();
    }

    PojoImplicitReindexingResolverPropertyNodeBuilder<U, ?> property(String propertyName) {
        return this.getOrCreatePropertyBuilder(propertyName);
    }

    void addDirtyPathTriggeringReindexing(BoundPojoModelPathValueNode<?, ?, ?> dirtyPathFromEntityType) {
        this.checkNotFrozen();
        this.markingNodeBuilder.addDirtyPathTriggeringReindexing(dirtyPathFromEntityType);
    }

    @Override
    void onFreeze(Set<PojoModelPathValueNode> dirtyPathsTriggeringReindexingCollector) {
        this.markingNodeBuilder.freeze();
        dirtyPathsTriggeringReindexingCollector.addAll(this.markingNodeBuilder.getDirtyPathsTriggeringReindexingIncludingNestedNodes());
        for (PojoImplicitReindexingResolverPropertyNodeBuilder<U, ?> builder : this.propertyNodeBuilders.values()) {
            builder.freeze();
            dirtyPathsTriggeringReindexingCollector.addAll(builder.getDirtyPathsTriggeringReindexingIncludingNestedNodes());
        }
    }

    @Override
    final <S> Optional<PojoImplicitReindexingResolverNode<T, S>> doBuild(PojoPathFilterFactory<S> pathFilterFactory, Set<PojoModelPathValueNode> allPotentialDirtyPaths) {
        this.checkFrozen();
        ArrayList immutableNestedNodes = new ArrayList();
        this.markingNodeBuilder.build(pathFilterFactory, allPotentialDirtyPaths).ifPresent(immutableNestedNodes::add);
        this.propertyNodeBuilders.values().stream().map(builder -> builder.build(pathFilterFactory, allPotentialDirtyPaths)).filter(Optional::isPresent).map(Optional::get).forEach(immutableNestedNodes::add);
        if (immutableNestedNodes.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.doBuild(this.createNested(immutableNestedNodes)));
    }

    abstract <S> PojoImplicitReindexingResolverNode<T, S> doBuild(PojoImplicitReindexingResolverNode<? super U, S> var1);

    private PojoImplicitReindexingResolverPropertyNodeBuilder<U, ?> getOrCreatePropertyBuilder(String propertyName) {
        return this.propertyNodeBuilders.computeIfAbsent(propertyName, this::createPropertyBuilder);
    }

    private PojoImplicitReindexingResolverPropertyNodeBuilder<U, ?> createPropertyBuilder(String propertyName) {
        this.checkNotFrozen();
        return new PojoImplicitReindexingResolverPropertyNodeBuilder(((BoundPojoModelPathTypeNode)this.getModelPath()).property(propertyName), this.buildingHelper);
    }
}

