/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.bridge.builtin.impl;

import org.hibernate.search.mapper.pojo.bridge.IdentifierBridge;
import org.hibernate.search.mapper.pojo.bridge.binding.IdentifierBindingContext;
import org.hibernate.search.mapper.pojo.bridge.mapping.programmatic.IdentifierBinder;
import org.hibernate.search.mapper.pojo.bridge.runtime.IdentifierBridgeFromDocumentIdentifierContext;
import org.hibernate.search.mapper.pojo.bridge.runtime.IdentifierBridgeToDocumentIdentifierContext;

public final class DefaultEnumIdentifierBridge<T extends Enum<T>>
implements IdentifierBridge<T> {
    private final Class<T> enumType;

    public DefaultEnumIdentifierBridge(Class<T> enumType) {
        this.enumType = enumType;
    }

    @Override
    public String toDocumentIdentifier(T propertyValue, IdentifierBridgeToDocumentIdentifierContext context) {
        return ((Enum)propertyValue).name();
    }

    @Override
    public T fromDocumentIdentifier(String documentIdentifier, IdentifierBridgeFromDocumentIdentifierContext context) {
        return Enum.valueOf(this.enumType, documentIdentifier);
    }

    @Override
    public boolean isCompatibleWith(IdentifierBridge<?> other) {
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        DefaultEnumIdentifierBridge castedOther = (DefaultEnumIdentifierBridge)other;
        return this.enumType.equals(castedOther.enumType);
    }

    public static class Binder
    implements IdentifierBinder {
        @Override
        public void bind(IdentifierBindingContext<?> context) {
            this.doBind(context, context.bridgedElement().rawType());
        }

        private <V extends Enum<V>> void doBind(IdentifierBindingContext<?> context, Class<V> enumType) {
            context.bridge(enumType, new DefaultEnumIdentifierBridge<V>(enumType));
        }
    }
}

