package org.hibernate.search.mapper.pojo.logging.impl;

import java.util.Locale;
import org.hibernate.search.mapper.pojo.model.path.PojoModelPathValueNode;
import java.io.Serializable;
import org.hibernate.search.util.AssertionFailure;
import org.jboss.logging.DelegatingBasicLogger;
import org.hibernate.search.util.SearchException;
import java.lang.String;
import org.jboss.logging.Logger;
import java.lang.Exception;
import java.lang.reflect.Type;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.lang.Object;
import java.util.Arrays;
import java.lang.reflect.Member;
import java.lang.IllegalArgumentException;


import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.DEBUG;

/**
 * Warning this class consists of generated code.
 */
public class Log_$logger extends DelegatingBasicLogger implements Log, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    public Log_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    private static final String unableToResolveDefaultIdentifierBridgeFromSourceType = "HSEARCH700001: Unable to find a default identifier bridge implementation for type '%1$s'";
    protected String unableToResolveDefaultIdentifierBridgeFromSourceType$str() {
        return unableToResolveDefaultIdentifierBridgeFromSourceType;
    }
    @Override
    public final SearchException unableToResolveDefaultIdentifierBridgeFromSourceType(final org.hibernate.search.mapper.pojo.model.spi.PojoTypeModel<?> sourceType) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToResolveDefaultIdentifierBridgeFromSourceType$str(), new org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter(sourceType)));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToResolveDefaultValueBridgeFromSourceType = "HSEARCH700002: Unable to find a default value bridge implementation for type '%1$s'";
    protected String unableToResolveDefaultValueBridgeFromSourceType$str() {
        return unableToResolveDefaultValueBridgeFromSourceType;
    }
    @Override
    public final SearchException unableToResolveDefaultValueBridgeFromSourceType(final org.hibernate.search.mapper.pojo.model.spi.PojoTypeModel<?> sourceType) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToResolveDefaultValueBridgeFromSourceType$str(), new org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter(sourceType)));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String missingBridgeReferenceInBridgeMapping = "HSEARCH700003: Annotation type '%2$s' is annotated with '%1$s', but neither a bridge reference nor a bridge builder reference was provided.";
    protected String missingBridgeReferenceInBridgeMapping$str() {
        return missingBridgeReferenceInBridgeMapping;
    }
    @Override
    public final SearchException missingBridgeReferenceInBridgeMapping(final Class<? extends java.lang.annotation.Annotation> metaAnnotationType, final Class<? extends java.lang.annotation.Annotation> annotationType) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), missingBridgeReferenceInBridgeMapping$str(), new org.hibernate.search.util.impl.common.logging.ClassFormatter(metaAnnotationType), new org.hibernate.search.util.impl.common.logging.ClassFormatter(annotationType)));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String missingBuilderReferenceInMarkerMapping = "HSEARCH700004: Annotation type '%2$s' is annotated with '%1$s', but the marker builder reference is empty.";
    protected String missingBuilderReferenceInMarkerMapping$str() {
        return missingBuilderReferenceInMarkerMapping;
    }
    @Override
    public final SearchException missingBuilderReferenceInMarkerMapping(final Class<? extends java.lang.annotation.Annotation> metaAnnotationType, final Class<? extends java.lang.annotation.Annotation> annotationType) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), missingBuilderReferenceInMarkerMapping$str(), new org.hibernate.search.util.impl.common.logging.ClassFormatter(metaAnnotationType), new org.hibernate.search.util.impl.common.logging.ClassFormatter(annotationType)));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidFieldDefiningBothBridgeReferenceAndBridgeBuilderReference = "HSEARCH700005: Annotation @GenericField on property '%1$s' defines both valueBridge and valueBridgeBuilder. Only one of those can be defined, not both.";
    protected String invalidFieldDefiningBothBridgeReferenceAndBridgeBuilderReference$str() {
        return invalidFieldDefiningBothBridgeReferenceAndBridgeBuilderReference;
    }
    @Override
    public final SearchException invalidFieldDefiningBothBridgeReferenceAndBridgeBuilderReference(final String property) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidFieldDefiningBothBridgeReferenceAndBridgeBuilderReference$str(), property));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidDocumentIdDefiningBothBridgeReferenceAndBridgeBuilderReference = "HSEARCH700006: Annotation @DocumentId on property '%1$s' defines both identifierBridge and identifierBridgeBuilder. Only one of those can be defined, not both.";
    protected String invalidDocumentIdDefiningBothBridgeReferenceAndBridgeBuilderReference$str() {
        return invalidDocumentIdDefiningBothBridgeReferenceAndBridgeBuilderReference;
    }
    @Override
    public final SearchException invalidDocumentIdDefiningBothBridgeReferenceAndBridgeBuilderReference(final String property) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidDocumentIdDefiningBothBridgeReferenceAndBridgeBuilderReference$str(), property));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotSearchOnEmptyTarget = "HSEARCH700007: Cannot query on an empty target. If you want to target all indexes, put Object.class in the collection of target types, or use the method of the same name, but without Class<?> parameters.";
    protected String cannotSearchOnEmptyTarget$str() {
        return cannotSearchOnEmptyTarget;
    }
    @Override
    public final SearchException cannotSearchOnEmptyTarget() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotSearchOnEmptyTarget$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToInferValueBridgeInputType = "HSEARCH700008: Could not auto-detect the input type for value bridge '%1$s'. There is a bug in Hibernate Search, please report it.";
    protected String unableToInferValueBridgeInputType$str() {
        return unableToInferValueBridgeInputType;
    }
    @Override
    public final AssertionFailure unableToInferValueBridgeInputType(final org.hibernate.search.mapper.pojo.bridge.ValueBridge<?, ?> bridge) {
        final AssertionFailure result = new AssertionFailure(String.format(getLoggingLocale(), unableToInferValueBridgeInputType$str(), bridge));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToInferValueBridgeIndexFieldType = "HSEARCH700009: Could not auto-detect the return type for value bridge '%1$s'. There is a bug in Hibernate Search, please report it.";
    protected String unableToInferValueBridgeIndexFieldType$str() {
        return unableToInferValueBridgeIndexFieldType;
    }
    @Override
    public final AssertionFailure unableToInferValueBridgeIndexFieldType(final org.hibernate.search.mapper.pojo.bridge.ValueBridge<?, ?> bridge) {
        final AssertionFailure result = new AssertionFailure(String.format(getLoggingLocale(), unableToInferValueBridgeIndexFieldType$str(), bridge));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidInputTypeForValueBridge = "HSEARCH700010: Value bridge '%1$s' cannot be applied to input type '%2$s'.";
    protected String invalidInputTypeForValueBridge$str() {
        return invalidInputTypeForValueBridge;
    }
    @Override
    public final SearchException invalidInputTypeForValueBridge(final org.hibernate.search.mapper.pojo.bridge.ValueBridge<?, ?> bridge, final org.hibernate.search.mapper.pojo.model.spi.PojoTypeModel<?> typeModel) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidInputTypeForValueBridge$str(), bridge, new org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter(typeModel)));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String missingFieldNameForGeoPointBridgeOnType = "HSEARCH700011: Missing field name for GeoPointBridge on type %1$s. The field name is mandatory when the bridge is applied on an type, optional when applied on a property.";
    protected String missingFieldNameForGeoPointBridgeOnType$str() {
        return missingFieldNameForGeoPointBridgeOnType;
    }
    @Override
    public final SearchException missingFieldNameForGeoPointBridgeOnType(final String typeName) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), missingFieldNameForGeoPointBridgeOnType$str(), typeName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotRequestTypeParameterOfUnparameterizedType = "HSEARCH700012: Requested type argument %3$s to type %2$s in implementing type %1$s, but %2$s doesn't declare any type parameter";
    protected String cannotRequestTypeParameterOfUnparameterizedType$str() {
        return cannotRequestTypeParameterOfUnparameterizedType;
    }
    @Override
    public final IllegalArgumentException cannotRequestTypeParameterOfUnparameterizedType(final Type type, final Class<?> rawSuperType, final int typeArgumentIndex) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), cannotRequestTypeParameterOfUnparameterizedType$str(), new org.hibernate.search.util.impl.common.logging.TypeFormatter(type), new org.hibernate.search.util.impl.common.logging.ClassFormatter(rawSuperType), typeArgumentIndex));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String typeParameterIndexOutOfBound = "HSEARCH700013: Requested type argument %3$s to type %2$s in implementing type %1$s, but %2$s only declares %4$s type parameter(s)";
    protected String typeParameterIndexOutOfBound$str() {
        return typeParameterIndexOutOfBound;
    }
    @Override
    public final IllegalArgumentException typeParameterIndexOutOfBound(final Type type, final Class<?> rawSuperType, final int typeArgumentIndex, final int typeParametersLength) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), typeParameterIndexOutOfBound$str(), new org.hibernate.search.util.impl.common.logging.TypeFormatter(type), new org.hibernate.search.util.impl.common.logging.ClassFormatter(rawSuperType), typeArgumentIndex, typeParametersLength));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidTypeParameterIndex = "HSEARCH700014: Requested type argument index %3$s to type %2$s in implementing type %1$s should be 0 or greater";
    protected String invalidTypeParameterIndex$str() {
        return invalidTypeParameterIndex;
    }
    @Override
    public final IllegalArgumentException invalidTypeParameterIndex(final Type type, final Class<?> rawSuperType, final int typeArgumentIndex) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidTypeParameterIndex$str(), new org.hibernate.search.util.impl.common.logging.TypeFormatter(type), new org.hibernate.search.util.impl.common.logging.ClassFormatter(rawSuperType), typeArgumentIndex));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotInferContainerValueExtractorClassTypePattern = "HSEARCH700015: Cannot interpret the type arguments to the ContainerValueExtractor interface in  implementation '%1$s'. Only the following implementations of ContainerValueExtractor are valid:  1) implementations setting both type parameters to *raw* types, e.g. class MyExtractor implements ContainerValueExtractor<MyBean, String>; 2) implementations setting the first type parameter to an array of an unbounded type variable, and setting the second parameter to the same type variable, e.g. MyExtractor<T> implements ContainerValueExtractor<T[], T> 3) implementations setting the first type parameter to a parameterized type with one argument set to an unbounded type variable and the other to unbounded wildcards, and setting the second type parameter to the same type variable, e.g. MyExtractor<T> implements ContainerValueExtractor<MyParameterizedBean<?, T, ?>, T>";
    protected String cannotInferContainerValueExtractorClassTypePattern$str() {
        return cannotInferContainerValueExtractorClassTypePattern;
    }
    @Override
    public final SearchException cannotInferContainerValueExtractorClassTypePattern(final Class<?> extractorClass) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotInferContainerValueExtractorClassTypePattern$str(), new org.hibernate.search.util.impl.common.logging.ClassFormatter(extractorClass)));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidContainerValueExtractorForType = "HSEARCH700016: Cannot apply the requested container value extractor '%1$s' to type '%2$s'";
    protected String invalidContainerValueExtractorForType$str() {
        return invalidContainerValueExtractorForType;
    }
    @Override
    public final SearchException invalidContainerValueExtractorForType(final Class<? extends org.hibernate.search.mapper.pojo.extractor.ContainerValueExtractor> extractorClass, final org.hibernate.search.mapper.pojo.model.spi.PojoGenericTypeModel<?> extractedType) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidContainerValueExtractorForType$str(), new org.hibernate.search.util.impl.common.logging.ClassFormatter(extractorClass), new org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter(extractedType)));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void createdPojoIndexedTypeManager(final org.hibernate.search.mapper.pojo.mapping.impl.PojoIndexedTypeManager<?, ?, ?> typeManager) {
        super.log.logf(FQCN, DEBUG, null, createdPojoIndexedTypeManager$str(), new org.hibernate.search.util.impl.common.logging.ToStringTreeAppendableMultilineFormatter(typeManager));
    }
    private static final String createdPojoIndexedTypeManager = "HSEARCH700017: Created POJO indexed type manager: %1$s";
    protected String createdPojoIndexedTypeManager$str() {
        return createdPojoIndexedTypeManager;
    }
    @Override
    public final void detectedEntityTypes(final java.util.Set<org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel<?>> entityTypes) {
        super.log.logf(FQCN, DEBUG, null, detectedEntityTypes$str(), entityTypes);
    }
    private static final String detectedEntityTypes = "HSEARCH700018: Detected entity types: %1$s";
    protected String detectedEntityTypes$str() {
        return detectedEntityTypes;
    }
    @Override
    public final void createdPojoContainedTypeManager(final org.hibernate.search.mapper.pojo.mapping.impl.PojoContainedTypeManager<?> typeManager) {
        super.log.logf(FQCN, DEBUG, null, createdPojoContainedTypeManager$str(), new org.hibernate.search.util.impl.common.logging.ToStringTreeAppendableMultilineFormatter(typeManager));
    }
    private static final String createdPojoContainedTypeManager = "HSEARCH700019: Created POJO contained type manager: %1$s";
    protected String createdPojoContainedTypeManager$str() {
        return createdPojoContainedTypeManager;
    }
    private static final String cannotInvertAssociation = "HSEARCH700020: Cannot find the inverse side of the association at path '%3$s' from type '%2$s' on type '%1$s'";
    protected String cannotInvertAssociation$str() {
        return cannotInvertAssociation;
    }
    @Override
    public final SearchException cannotInvertAssociation(final org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel<?> inverseSideTypeModel, final org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel<?> typeModel, final PojoModelPathValueNode associationPath) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotInvertAssociation$str(), new org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter(inverseSideTypeModel), new org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter(typeModel), new org.hibernate.search.mapper.pojo.logging.spi.PojoModelPathFormatter(associationPath)));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotApplyInvertAssociationPath = "HSEARCH700021: Cannot apply the path of the inverse association '%2$s' from type '%1$s'. Association on the original side (which was being inverted) was '%4$s' on type '%3$s'. Error was: '%5$s'";
    protected String cannotApplyInvertAssociationPath$str() {
        return cannotApplyInvertAssociationPath;
    }
    @Override
    public final SearchException cannotApplyInvertAssociationPath(final org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel<?> inverseSideTypeModel, final PojoModelPathValueNode inverseSideAssociationPath, final org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel<?> originalSideTypeModel, final PojoModelPathValueNode originalSideAssociationPath, final String errorMessage, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotApplyInvertAssociationPath$str(), new org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter(inverseSideTypeModel), new org.hibernate.search.mapper.pojo.logging.spi.PojoModelPathFormatter(inverseSideAssociationPath), new org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter(originalSideTypeModel), new org.hibernate.search.mapper.pojo.logging.spi.PojoModelPathFormatter(originalSideAssociationPath), errorMessage), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String incorrectTargetTypeForInverseAssociation = "HSEARCH700022: The inverse association targets type '%1$s', but a supertype or subtype of '%2$s' was expected.";
    protected String incorrectTargetTypeForInverseAssociation$str() {
        return incorrectTargetTypeForInverseAssociation;
    }
    @Override
    public final SearchException incorrectTargetTypeForInverseAssociation(final org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel<?> inverseAssociationTargetType, final org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel<?> entityType) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), incorrectTargetTypeForInverseAssociation$str(), new org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter(inverseAssociationTargetType), new org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter(entityType)));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String missingInversePathInAssociationInverseSideMapping = "HSEARCH700023: Property '%2$s' from type '%1$s' is annotated with @AssociationInverseSide, but the inverse path is empty.";
    protected String missingInversePathInAssociationInverseSideMapping$str() {
        return missingInversePathInAssociationInverseSideMapping;
    }
    @Override
    public final SearchException missingInversePathInAssociationInverseSideMapping(final org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel<?> typeModel, final String propertyName) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), missingInversePathInAssociationInverseSideMapping$str(), new org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter(typeModel), propertyName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String infiniteRecursionForAssociationEmbeddeds = "HSEARCH700024: Found an infinite embedded recursion involving path '%2$s' on type '%1$s'";
    protected String infiniteRecursionForAssociationEmbeddeds$str() {
        return infiniteRecursionForAssociationEmbeddeds;
    }
    @Override
    public final SearchException infiniteRecursionForAssociationEmbeddeds(final org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel<?> typeModel, final PojoModelPathValueNode path) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), infiniteRecursionForAssociationEmbeddeds$str(), new org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter(typeModel), new org.hibernate.search.mapper.pojo.logging.spi.PojoModelPathFormatter(path)));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void cannotAccessRepeateableContainingAnnotationValue(final Class<?> containingAnnotationType, final Throwable e) {
        super.log.logf(FQCN, INFO, e, cannotAccessRepeateableContainingAnnotationValue$str(), new org.hibernate.search.util.impl.common.logging.ClassFormatter(containingAnnotationType));
    }
    private static final String cannotAccessRepeateableContainingAnnotationValue = "HSEARCH700025: Cannot access the value of containing annotation '%1$s'. Ignoring annotation.";
    protected String cannotAccessRepeateableContainingAnnotationValue$str() {
        return cannotAccessRepeateableContainingAnnotationValue;
    }
    private static final String conflictingBridgeReferenceInBridgeMapping = "HSEARCH700026: Annotation type '%2$s' is annotated with '%1$s', but both a bridge reference and a bridge builder reference were provided. Only one can be provided.";
    protected String conflictingBridgeReferenceInBridgeMapping$str() {
        return conflictingBridgeReferenceInBridgeMapping;
    }
    @Override
    public final SearchException conflictingBridgeReferenceInBridgeMapping(final Class<? extends java.lang.annotation.Annotation> metaAnnotationType, final Class<? extends java.lang.annotation.Annotation> annotationType) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), conflictingBridgeReferenceInBridgeMapping$str(), new org.hibernate.search.util.impl.common.logging.ClassFormatter(metaAnnotationType), new org.hibernate.search.util.impl.common.logging.ClassFormatter(annotationType)));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String missingEntityTypeMetadata = "HSEARCH700027: Type '%1$s' is not marked as an entity type, yet it is indexed or targeted by an association from an indexed type. Please check your configuration.";
    protected String missingEntityTypeMetadata$str() {
        return missingEntityTypeMetadata;
    }
    @Override
    public final SearchException missingEntityTypeMetadata(final org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel<?> typeModel) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), missingEntityTypeMetadata$str(), new org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter(typeModel)));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String missingIdentifierMapping = "HSEARCH700028: There isn't any explicit document ID mapping for indexed type '%1$s', and the entity ID cannot be used as a default because it is unknown.";
    protected String missingIdentifierMapping$str() {
        return missingIdentifierMapping;
    }
    @Override
    public final SearchException missingIdentifierMapping(final org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel<?> typeModel) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), missingIdentifierMapping$str(), new org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter(typeModel)));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String missingPathInIndexingDependencyDerivedFrom = "HSEARCH700029: Property '%2$s' from type '%1$s' is annotated with @IndexingDependency, but 'derivedFrom' contains an empty path.";
    protected String missingPathInIndexingDependencyDerivedFrom$str() {
        return missingPathInIndexingDependencyDerivedFrom;
    }
    @Override
    public final SearchException missingPathInIndexingDependencyDerivedFrom(final org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel<?> typeModel, final String propertyName) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), missingPathInIndexingDependencyDerivedFrom$str(), new org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter(typeModel), propertyName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String infiniteRecursionForDerivedFrom = "HSEARCH700030: Found a cyclic dependency between derived properties involving path '%2$s' on type '%1$s'. Derived properties cannot be marked as derived from themselves, even indirectly through other  derived properties. If your model actually contains such cyclic dependency,  you should consider disabling automatic reindexing, at least partially  using @IndexingDependency(reindexOnUpdate = ReindexOnUpdate.NO) on one of the properties in the cycle.";
    protected String infiniteRecursionForDerivedFrom$str() {
        return infiniteRecursionForDerivedFrom;
    }
    @Override
    public final SearchException infiniteRecursionForDerivedFrom(final org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel<?> typeModel, final PojoModelPathValueNode path) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), infiniteRecursionForDerivedFrom$str(), new org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter(typeModel), new org.hibernate.search.mapper.pojo.logging.spi.PojoModelPathFormatter(path)));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidFieldEncodingForFullTextFieldMapping = "HSEARCH700031: This property is mapped to a full-text field, but with a value bridge that creates a non-String or otherwise incompatible field. Make sure to use a compatible bridge. Details: the value bridge's bind() method returned context '%1$s', which does not extend the expected '%2$s' interface.";
    protected String invalidFieldEncodingForFullTextFieldMapping$str() {
        return invalidFieldEncodingForFullTextFieldMapping;
    }
    @Override
    public final SearchException invalidFieldEncodingForFullTextFieldMapping(final org.hibernate.search.engine.backend.document.model.dsl.IndexSchemaFieldTypedContext<?, ?> context, final Class<?> expectedContextType) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidFieldEncodingForFullTextFieldMapping$str(), context, new org.hibernate.search.util.impl.common.logging.ClassFormatter(expectedContextType)));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidFieldEncodingForKeywordFieldMapping = "HSEARCH700032: This property is mapped to a keyword field, but with a value bridge that creates a non-String or otherwise incompatible field. Make sure to use a compatible bridge. Details: the value bridge's bind() method returned context '%1$s', which does not extend the expected '%2$s' interface.";
    protected String invalidFieldEncodingForKeywordFieldMapping$str() {
        return invalidFieldEncodingForKeywordFieldMapping;
    }
    @Override
    public final SearchException invalidFieldEncodingForKeywordFieldMapping(final org.hibernate.search.engine.backend.document.model.dsl.IndexSchemaFieldTypedContext<?, ?> context, final Class<?> expectedContextType) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidFieldEncodingForKeywordFieldMapping$str(), context, new org.hibernate.search.util.impl.common.logging.ClassFormatter(expectedContextType)));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String errorInvokingMember = "HSEARCH700033: Exception while invoking '%1$s' on '%2$s'.";
    protected String errorInvokingMember$str() {
        return errorInvokingMember;
    }
    @Override
    public final SearchException errorInvokingMember(final Member member, final Object component, final Throwable e) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), errorInvokingMember$str(), member, component), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String propertyMarkerNotFound = "HSEARCH700034: Could not find a property with the '%1$s' marker for field '%2$s' (marker set: '%3$s').";
    protected String propertyMarkerNotFound$str() {
        return propertyMarkerNotFound;
    }
    @Override
    public final SearchException propertyMarkerNotFound(final String markerName, final String fieldName, final String markerSet) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), propertyMarkerNotFound$str(), markerName, fieldName, markerSet));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String multiplePropertiesForMarker = "HSEARCH700035: Found multiple properties with the '%1$s' marker for field '%2$s' (marker set: '%3$s').";
    protected String multiplePropertiesForMarker$str() {
        return multiplePropertiesForMarker;
    }
    @Override
    public final SearchException multiplePropertiesForMarker(final String markerName, final String fieldName, final String markerSet) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), multiplePropertiesForMarker$str(), markerName, fieldName, markerSet));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String notIndexedType = "HSEARCH700036: Type '%1$s' is not indexed and hasn't any indexed supertype.";
    protected String notIndexedType$str() {
        return notIndexedType;
    }
    @Override
    public final SearchException notIndexedType(final Class<?> targetedType) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), notIndexedType$str(), new org.hibernate.search.util.impl.common.logging.ClassFormatter(targetedType)));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String notIndexedTypeNorAsDelegate = "HSEARCH700037: Cannot work on type %1$s, because it is not indexed, neither directly nor as a contained entity in another type.";
    protected String notIndexedTypeNorAsDelegate$str() {
        return notIndexedTypeNorAsDelegate;
    }
    @Override
    public final SearchException notIndexedTypeNorAsDelegate(final Class<?> targetedType) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), notIndexedTypeNorAsDelegate$str(), new org.hibernate.search.util.impl.common.logging.ClassFormatter(targetedType)));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String nullProvidedIdentifier = "HSEARCH700038: The identifier for this entity should always be provided, but the provided identifier was null.";
    protected String nullProvidedIdentifier$str() {
        return nullProvidedIdentifier;
    }
    @Override
    public final SearchException nullProvidedIdentifier() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), nullProvidedIdentifier$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String incompatibleRequestedType = "HSEARCH700039: Requested incompatible type for '%1$s': '%2$s'";
    protected String incompatibleRequestedType$str() {
        return incompatibleRequestedType;
    }
    @Override
    public final SearchException incompatibleRequestedType(final PojoModelPathValueNode accessor, final Class<?> requestedType) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), incompatibleRequestedType$str(), new org.hibernate.search.mapper.pojo.logging.spi.PojoModelPathFormatter(accessor), new org.hibernate.search.util.impl.common.logging.ClassFormatter(requestedType)));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}
