/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.bridge.builtin.impl;

import org.hibernate.search.engine.backend.document.converter.FromIndexFieldValueConverter;
import org.hibernate.search.engine.backend.document.converter.runtime.FromIndexFieldValueConvertContext;
import org.hibernate.search.engine.backend.document.model.dsl.StandardIndexSchemaFieldTypedContext;
import org.hibernate.search.mapper.pojo.bridge.ValueBridge;
import org.hibernate.search.mapper.pojo.bridge.binding.ValueBridgeBindingContext;
import org.hibernate.search.mapper.pojo.bridge.runtime.ValueBridgeToIndexedValueContext;

public final class DefaultEnumValueBridge<V extends Enum<V>>
implements ValueBridge<V, String> {
    private Class<V> enumType;

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.enumType.getName() + "]";
    }

    @Override
    public StandardIndexSchemaFieldTypedContext<?, String> bind(ValueBridgeBindingContext<V> context) {
        this.enumType = context.getBridgedElement().getRawType();
        return (StandardIndexSchemaFieldTypedContext)context.getIndexSchemaFieldContext().asString().projectionConverter(new PojoDefaultEnumFromIndexFieldValueConverter(this.enumType));
    }

    @Override
    public String toIndexedValue(V value, ValueBridgeToIndexedValueContext context) {
        return value == null ? null : ((Enum)value).name();
    }

    @Override
    public V cast(Object value) {
        return (V)((Enum)this.enumType.cast(value));
    }

    @Override
    public boolean isCompatibleWith(ValueBridge<?, ?> other) {
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        DefaultEnumValueBridge castedOther = (DefaultEnumValueBridge)other;
        return this.enumType.equals(castedOther.enumType);
    }

    private static class PojoDefaultEnumFromIndexFieldValueConverter<V extends Enum<V>>
    implements FromIndexFieldValueConverter<String, V> {
        private final Class<V> enumType;

        private PojoDefaultEnumFromIndexFieldValueConverter(Class<V> enumType) {
            this.enumType = enumType;
        }

        public boolean isConvertedTypeAssignableTo(Class<?> superTypeCandidate) {
            return superTypeCandidate.isAssignableFrom(this.enumType);
        }

        public V convert(String indexedValue, FromIndexFieldValueConvertContext context) {
            return indexedValue == null ? null : (V)Enum.valueOf(this.enumType, indexedValue);
        }

        public boolean isCompatibleWith(FromIndexFieldValueConverter<?, ?> other) {
            if (!this.getClass().equals(other.getClass())) {
                return false;
            }
            PojoDefaultEnumFromIndexFieldValueConverter castedOther = (PojoDefaultEnumFromIndexFieldValueConverter)other;
            return this.enumType.equals(castedOther.enumType);
        }
    }
}

