/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.bridge.builtin.impl;

import java.time.Instant;
import java.util.Date;
import org.hibernate.search.engine.backend.document.converter.FromIndexFieldValueConverter;
import org.hibernate.search.engine.backend.document.converter.runtime.FromIndexFieldValueConvertContext;
import org.hibernate.search.engine.backend.document.model.dsl.StandardIndexSchemaFieldTypedContext;
import org.hibernate.search.mapper.pojo.bridge.ValueBridge;
import org.hibernate.search.mapper.pojo.bridge.binding.ValueBridgeBindingContext;
import org.hibernate.search.mapper.pojo.bridge.runtime.ValueBridgeToIndexedValueContext;

public final class DefaultJavaUtilDateValueBridge
implements ValueBridge<Date, Instant> {
    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public StandardIndexSchemaFieldTypedContext<?, Instant> bind(ValueBridgeBindingContext<Date> context) {
        return (StandardIndexSchemaFieldTypedContext)context.getIndexSchemaFieldContext().asInstant().projectionConverter((FromIndexFieldValueConverter)PojoDefaultDateFromIndexFieldValueConverter.INSTANCE);
    }

    @Override
    public Instant toIndexedValue(Date value, ValueBridgeToIndexedValueContext context) {
        return value == null ? null : value.toInstant();
    }

    @Override
    public Date cast(Object value) {
        return (Date)value;
    }

    @Override
    public boolean isCompatibleWith(ValueBridge<?, ?> other) {
        return this.getClass().equals(other.getClass());
    }

    private static class PojoDefaultDateFromIndexFieldValueConverter
    implements FromIndexFieldValueConverter<Instant, Date> {
        private static final PojoDefaultDateFromIndexFieldValueConverter INSTANCE = new PojoDefaultDateFromIndexFieldValueConverter();

        private PojoDefaultDateFromIndexFieldValueConverter() {
        }

        public boolean isConvertedTypeAssignableTo(Class<?> superTypeCandidate) {
            return superTypeCandidate.isAssignableFrom(Date.class);
        }

        public Date convert(Instant value, FromIndexFieldValueConvertContext context) {
            return value == null ? null : Date.from(value);
        }

        public boolean isCompatibleWith(FromIndexFieldValueConverter<?, ?> other) {
            return INSTANCE.equals(other);
        }
    }
}

