/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.bridge.builtin.impl;

import org.hibernate.search.engine.backend.document.converter.FromIndexFieldValueConverter;
import org.hibernate.search.engine.backend.document.converter.spi.PassThroughFromIndexFieldValueConverter;
import org.hibernate.search.engine.backend.document.model.dsl.StandardIndexSchemaFieldTypedContext;
import org.hibernate.search.mapper.pojo.bridge.ValueBridge;
import org.hibernate.search.mapper.pojo.bridge.binding.ValueBridgeBindingContext;
import org.hibernate.search.mapper.pojo.bridge.runtime.ValueBridgeToIndexedValueContext;
import org.hibernate.search.util.impl.common.Contracts;

public final class PassThroughValueBridge<F>
implements ValueBridge<F, F> {
    private final Class<F> fieldType;

    public PassThroughValueBridge(Class<F> fieldType) {
        Contracts.assertNotNull(fieldType, (String)"fieldType");
        this.fieldType = fieldType;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.fieldType.getName() + "]";
    }

    @Override
    public StandardIndexSchemaFieldTypedContext<?, F> bind(ValueBridgeBindingContext<F> context) {
        return (StandardIndexSchemaFieldTypedContext)context.getIndexSchemaFieldContext().as(this.fieldType).projectionConverter((FromIndexFieldValueConverter)new PassThroughFromIndexFieldValueConverter(this.fieldType));
    }

    @Override
    public F cast(Object value) {
        return this.fieldType.cast(value);
    }

    @Override
    public F toIndexedValue(F value, ValueBridgeToIndexedValueContext context) {
        return value;
    }

    @Override
    public boolean isCompatibleWith(ValueBridge<?, ?> other) {
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        PassThroughValueBridge castedOther = (PassThroughValueBridge)other;
        return this.fieldType.equals(castedOther.fieldType);
    }
}

