/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.bridge.impl;

import org.hibernate.search.engine.environment.bean.BeanProvider;
import org.hibernate.search.engine.environment.bean.BeanReference;
import org.hibernate.search.mapper.pojo.bridge.mapping.BridgeBuildContext;
import org.hibernate.search.mapper.pojo.bridge.mapping.BridgeBuilder;

public class BeanResolverBridgeBuilder<T>
implements BridgeBuilder<T> {
    private final Class<T> expectedType;
    private final BeanReference beanReference;

    public BeanResolverBridgeBuilder(Class<T> expectedType, BeanReference beanReference) {
        this.expectedType = expectedType;
        this.beanReference = beanReference;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.beanReference + "]";
    }

    @Override
    public T build(BridgeBuildContext buildContext) {
        BeanProvider beanProvider = buildContext.getBeanProvider();
        return (T)beanProvider.getBean(this.beanReference, this.expectedType);
    }
}

