/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.bridge.impl;

import java.lang.invoke.MethodHandles;
import java.time.Instant;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.hibernate.search.mapper.pojo.bridge.IdentifierBridge;
import org.hibernate.search.mapper.pojo.bridge.ValueBridge;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.DefaultEnumIdentifierBridge;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.DefaultEnumValueBridge;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.DefaultIntegerIdentifierBridge;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.DefaultJavaUtilDateValueBridge;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.DefaultLongIdentifierBridge;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.PassThroughValueBridge;
import org.hibernate.search.mapper.pojo.bridge.mapping.BridgeBuilder;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.mapper.pojo.model.spi.PojoGenericTypeModel;
import org.hibernate.search.mapper.pojo.model.typepattern.impl.TypePatternMatcher;
import org.hibernate.search.mapper.pojo.model.typepattern.impl.TypePatternMatcherFactory;
import org.hibernate.search.util.impl.common.LoggerFactory;

public final class BridgeResolver {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final Map<Class<?>, BridgeBuilder<? extends IdentifierBridge<?>>> exactRawTypeIdentifierBridgeMappings = new HashMap();
    private final Map<Class<?>, BridgeBuilder<? extends ValueBridge<?, ?>>> exactRawTypeValueBridgeMappings = new HashMap();
    private final List<TypePatternBridgeMapping<? extends IdentifierBridge<?>>> typePatternIdentifierBridgeMappings = new ArrayList();
    private final List<TypePatternBridgeMapping<? extends ValueBridge<?, ?>>> typePatternValueBridgeMappings = new ArrayList();

    public BridgeResolver(TypePatternMatcherFactory typePatternMatcherFactory) {
        TypePatternMatcher concreteEnumPattern = typePatternMatcherFactory.createRawSuperTypeMatcher(Enum.class).and(typePatternMatcherFactory.createExactRawTypeMatcher(Enum.class).negate());
        this.addIdentifierBridgeForExactRawType(Integer.class, ignored -> new DefaultIntegerIdentifierBridge());
        this.addIdentifierBridgeForExactRawType(Long.class, ignored -> new DefaultLongIdentifierBridge());
        this.addIdentifierBridgeForTypePattern(concreteEnumPattern, ignored -> new DefaultEnumIdentifierBridge());
        this.addValueBridgeForExactRawType(Integer.class, ignored -> new PassThroughValueBridge<Integer>(Integer.class));
        this.addValueBridgeForExactRawType(Long.class, ignored -> new PassThroughValueBridge<Long>(Long.class));
        this.addValueBridgeForExactRawType(Boolean.class, ignored -> new PassThroughValueBridge<Boolean>(Boolean.class));
        this.addValueBridgeForExactRawType(String.class, ignored -> new PassThroughValueBridge<String>(String.class));
        this.addValueBridgeForExactRawType(LocalDate.class, ignored -> new PassThroughValueBridge<LocalDate>(LocalDate.class));
        this.addValueBridgeForExactRawType(Instant.class, ignored -> new PassThroughValueBridge<Instant>(Instant.class));
        this.addValueBridgeForExactRawType(Date.class, ignored -> new DefaultJavaUtilDateValueBridge());
        this.addValueBridgeForTypePattern(concreteEnumPattern, ignored -> new DefaultEnumValueBridge());
    }

    public BridgeBuilder<? extends IdentifierBridge<?>> resolveIdentifierBridgeForType(PojoGenericTypeModel<?> sourceType) {
        BridgeBuilder result = BridgeResolver.getBridgeBuilderOrNull(sourceType, this.exactRawTypeIdentifierBridgeMappings, this.typePatternIdentifierBridgeMappings);
        if (result == null) {
            throw log.unableToResolveDefaultIdentifierBridgeFromSourceType(sourceType);
        }
        return result;
    }

    public BridgeBuilder<? extends ValueBridge<?, ?>> resolveValueBridgeForType(PojoGenericTypeModel<?> sourceType) {
        BridgeBuilder result = BridgeResolver.getBridgeBuilderOrNull(sourceType, this.exactRawTypeValueBridgeMappings, this.typePatternValueBridgeMappings);
        if (result == null) {
            throw log.unableToResolveDefaultValueBridgeFromSourceType(sourceType);
        }
        return result;
    }

    private <I> void addIdentifierBridgeForExactRawType(Class<I> type, BridgeBuilder<? extends IdentifierBridge<I>> builder) {
        this.exactRawTypeIdentifierBridgeMappings.put(type, builder);
    }

    private void addIdentifierBridgeForTypePattern(TypePatternMatcher typePatternMatcher, BridgeBuilder<? extends IdentifierBridge<?>> builder) {
        this.typePatternIdentifierBridgeMappings.add(new TypePatternBridgeMapping(typePatternMatcher, builder));
    }

    private <V> void addValueBridgeForExactRawType(Class<V> type, BridgeBuilder<? extends ValueBridge<? super V, ?>> builder) {
        this.exactRawTypeValueBridgeMappings.put(type, builder);
    }

    private void addValueBridgeForTypePattern(TypePatternMatcher typePatternMatcher, BridgeBuilder<? extends ValueBridge<?, ?>> builder) {
        this.typePatternValueBridgeMappings.add(new TypePatternBridgeMapping(typePatternMatcher, builder));
    }

    private static <B> BridgeBuilder<? extends B> getBridgeBuilderOrNull(PojoGenericTypeModel<?> sourceType, Map<Class<?>, BridgeBuilder<? extends B>> exactRawTypeBridgeMappings, List<TypePatternBridgeMapping<? extends B>> typePatternBridgeMappings) {
        Class rawType = sourceType.getRawType().getJavaClass();
        BridgeBuilder<? extends B> result = exactRawTypeBridgeMappings.get(rawType);
        if (result == null) {
            Iterator<TypePatternBridgeMapping<B>> mappingIterator = typePatternBridgeMappings.iterator();
            while (result == null && mappingIterator.hasNext()) {
                result = mappingIterator.next().getBuilderIfMatching(sourceType);
            }
        }
        return result;
    }

    private static final class TypePatternBridgeMapping<B> {
        private final TypePatternMatcher matcher;
        private final BridgeBuilder<B> builder;

        TypePatternBridgeMapping(TypePatternMatcher matcher, BridgeBuilder<B> builder) {
            this.matcher = matcher;
            this.builder = builder;
        }

        BridgeBuilder<B> getBuilderIfMatching(PojoGenericTypeModel<?> typeModel) {
            if (this.matcher.matches(typeModel)) {
                return this.builder;
            }
            return null;
        }
    }
}

