/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.dirtiness.building.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.hibernate.search.mapper.pojo.dirtiness.ReindexOnUpdate;
import org.hibernate.search.mapper.pojo.dirtiness.building.impl.PojoAssociationPathInverter;
import org.hibernate.search.mapper.pojo.dirtiness.building.impl.PojoImplicitReindexingResolverBuilder;
import org.hibernate.search.mapper.pojo.dirtiness.building.impl.PojoIndexingDependencyCollectorTypeNode;
import org.hibernate.search.mapper.pojo.dirtiness.impl.PojoImplicitReindexingResolver;
import org.hibernate.search.mapper.pojo.extractor.ContainerValueExtractor;
import org.hibernate.search.mapper.pojo.extractor.ContainerValueExtractorPath;
import org.hibernate.search.mapper.pojo.extractor.impl.BoundContainerValueExtractorPath;
import org.hibernate.search.mapper.pojo.extractor.impl.ContainerValueExtractorBinder;
import org.hibernate.search.mapper.pojo.model.additionalmetadata.building.impl.PojoTypeAdditionalMetadataProvider;
import org.hibernate.search.mapper.pojo.model.additionalmetadata.impl.PojoTypeAdditionalMetadata;
import org.hibernate.search.mapper.pojo.model.path.PojoModelPathValueNode;
import org.hibernate.search.mapper.pojo.model.path.spi.PojoPathFilterFactory;
import org.hibernate.search.mapper.pojo.model.spi.PojoGenericTypeModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoTypeModel;

public final class PojoImplicitReindexingResolverBuildingHelper {
    private final ContainerValueExtractorBinder extractorBinder;
    private final PojoTypeAdditionalMetadataProvider typeAdditionalMetadataProvider;
    private final PojoAssociationPathInverter pathInverter;
    private final Set<PojoRawTypeModel<?>> entityTypes;
    private final Map<PojoRawTypeModel<?>, Set<PojoRawTypeModel<?>>> concreteEntitySubTypesByEntitySuperType = new HashMap();
    private final Map<PojoRawTypeModel<?>, PojoImplicitReindexingResolverBuilder<?>> builderByType = new HashMap();

    public PojoImplicitReindexingResolverBuildingHelper(ContainerValueExtractorBinder extractorBinder, PojoTypeAdditionalMetadataProvider typeAdditionalMetadataProvider, PojoAssociationPathInverter pathInverter, Set<PojoRawTypeModel<?>> entityTypes) {
        this.extractorBinder = extractorBinder;
        this.typeAdditionalMetadataProvider = typeAdditionalMetadataProvider;
        this.pathInverter = pathInverter;
        this.entityTypes = entityTypes;
        for (PojoRawTypeModel<?> pojoRawTypeModel : entityTypes) {
            if (pojoRawTypeModel.isAbstract()) continue;
            pojoRawTypeModel.getAscendingSuperTypes().forEach(superType -> this.concreteEntitySubTypesByEntitySuperType.computeIfAbsent((PojoRawTypeModel<?>)superType, ignored -> new LinkedHashSet()).add(entityType));
        }
        for (Map.Entry entry : this.concreteEntitySubTypesByEntitySuperType.entrySet()) {
            entry.setValue(Collections.unmodifiableSet((Set)entry.getValue()));
        }
    }

    public <T> PojoIndexingDependencyCollectorTypeNode<T> createDependencyCollector(PojoRawTypeModel<T> typeModel) {
        return new PojoIndexingDependencyCollectorTypeNode<T>(typeModel, this);
    }

    public <T, S> Optional<PojoImplicitReindexingResolver<T, S>> build(PojoRawTypeModel<T> typeModel, PojoPathFilterFactory<S> pathFilterFactory) {
        PojoImplicitReindexingResolverBuilder<?> builder = this.builderByType.get(typeModel);
        if (builder == null) {
            return Optional.empty();
        }
        return builder.build(pathFilterFactory);
    }

    PojoAssociationPathInverter getPathInverter() {
        return this.pathInverter;
    }

    boolean isEntity(PojoRawTypeModel<?> typeModel) {
        return this.entityTypes.contains(typeModel);
    }

    Set<? extends PojoRawTypeModel<?>> getConcreteEntitySubTypesForEntitySuperType(PojoRawTypeModel<?> superTypeModel) {
        return this.concreteEntitySubTypesByEntitySuperType.computeIfAbsent(superTypeModel, ignored -> Collections.emptySet());
    }

    <T> PojoImplicitReindexingResolverBuilder<T> getOrCreateResolverBuilder(PojoRawTypeModel<T> rawTypeModel) {
        PojoImplicitReindexingResolverBuilder<Object> builder = this.builderByType.get(rawTypeModel);
        if (builder == null) {
            builder = new PojoImplicitReindexingResolverBuilder<T>(rawTypeModel, this);
            this.builderByType.put(rawTypeModel, builder);
        }
        return builder;
    }

    <T> BoundContainerValueExtractorPath<T, ?> bindExtractorPath(PojoGenericTypeModel<T> typeModel, ContainerValueExtractorPath extractorPath) {
        return this.extractorBinder.bindPath(typeModel, extractorPath);
    }

    <V, T> ContainerValueExtractor<? super T, V> createExtractors(BoundContainerValueExtractorPath<T, V> boundExtractorPath) {
        return this.extractorBinder.create(boundExtractorPath);
    }

    ReindexOnUpdate getReindexOnUpdate(ReindexOnUpdate parentReindexOnUpdate, PojoTypeModel<?> typeModel, String propertyName, ContainerValueExtractorPath extractorPath) {
        if (ReindexOnUpdate.NO.equals((Object)parentReindexOnUpdate)) {
            return ReindexOnUpdate.NO;
        }
        PojoTypeAdditionalMetadata typeAdditionalMetadata = this.typeAdditionalMetadataProvider.get(typeModel.getRawType());
        Optional<ReindexOnUpdate> reindexOnUpdateOptional = typeAdditionalMetadata.getPropertyAdditionalMetadata(propertyName).getValueAdditionalMetadata(extractorPath).getReindexOnUpdate();
        if (!reindexOnUpdateOptional.isPresent() && this.extractorBinder.isDefaultExtractorPath(typeModel.getProperty(propertyName).getTypeModel(), extractorPath)) {
            reindexOnUpdateOptional = typeAdditionalMetadata.getPropertyAdditionalMetadata(propertyName).getValueAdditionalMetadata(ContainerValueExtractorPath.defaultExtractors()).getReindexOnUpdate();
        }
        return reindexOnUpdateOptional.orElse(ReindexOnUpdate.DEFAULT);
    }

    Set<PojoModelPathValueNode> getDerivedFrom(PojoTypeModel<?> typeModel, String propertyName, ContainerValueExtractorPath extractorPath) {
        PojoTypeAdditionalMetadata typeAdditionalMetadata = this.typeAdditionalMetadataProvider.get(typeModel.getRawType());
        Set<PojoModelPathValueNode> derivedFrom = typeAdditionalMetadata.getPropertyAdditionalMetadata(propertyName).getValueAdditionalMetadata(extractorPath).getDerivedFrom();
        if (derivedFrom.isEmpty() && this.extractorBinder.isDefaultExtractorPath(typeModel.getProperty(propertyName).getTypeModel(), extractorPath)) {
            derivedFrom = typeAdditionalMetadata.getPropertyAdditionalMetadata(propertyName).getValueAdditionalMetadata(ContainerValueExtractorPath.defaultExtractors()).getDerivedFrom();
        }
        return derivedFrom;
    }
}

