/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.dirtiness.impl;

import java.util.Collection;
import java.util.stream.Stream;
import org.hibernate.search.mapper.pojo.dirtiness.impl.PojoImplicitReindexingResolverNode;
import org.hibernate.search.mapper.pojo.dirtiness.impl.PojoReindexingCollector;
import org.hibernate.search.mapper.pojo.extractor.ContainerValueExtractor;
import org.hibernate.search.mapper.pojo.model.spi.PojoRuntimeIntrospector;
import org.hibernate.search.util.impl.common.ToStringTreeBuilder;

public class PojoImplicitReindexingResolverContainerElementNode<C, S, V>
extends PojoImplicitReindexingResolverNode<C, S> {
    private final ContainerValueExtractor<C, V> extractor;
    private final Collection<PojoImplicitReindexingResolverNode<V, S>> nestedNodes;

    public PojoImplicitReindexingResolverContainerElementNode(ContainerValueExtractor<C, V> extractor, Collection<PojoImplicitReindexingResolverNode<V, S>> nestedNodes) {
        this.extractor = extractor;
        this.nestedNodes = nestedNodes;
    }

    public void appendTo(ToStringTreeBuilder builder) {
        builder.attribute("class", (Object)this.getClass().getSimpleName());
        builder.attribute("extractor", this.extractor);
        builder.startList("nestedNodes");
        for (PojoImplicitReindexingResolverNode<V, S> nestedNode : this.nestedNodes) {
            builder.value(nestedNode);
        }
        builder.endList();
    }

    @Override
    public void resolveEntitiesToReindex(PojoReindexingCollector collector, PojoRuntimeIntrospector runtimeIntrospector, C dirty, S dirtinessState) {
        try (Stream<V> stream = this.extractor.extract(dirty);){
            stream.forEach(containerElement -> this.resolveEntitiesToReindexForContainerElement(collector, runtimeIntrospector, containerElement, dirtinessState));
        }
    }

    private void resolveEntitiesToReindexForContainerElement(PojoReindexingCollector collector, PojoRuntimeIntrospector runtimeIntrospector, V containerElement, S dirtinessState) {
        if (containerElement != null) {
            for (PojoImplicitReindexingResolverNode<V, S> node : this.nestedNodes) {
                node.resolveEntitiesToReindex(collector, runtimeIntrospector, containerElement, dirtinessState);
            }
        }
    }
}

