/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.extractor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.hibernate.search.mapper.pojo.extractor.ContainerValueExtractor;

public class ContainerValueExtractorPath {
    private static final ContainerValueExtractorPath DEFAULT = new ContainerValueExtractorPath(true, Collections.emptyList());
    private static final ContainerValueExtractorPath NONE = new ContainerValueExtractorPath(false, Collections.emptyList());
    private final boolean applyDefaultExtractors;
    private final List<? extends Class<? extends ContainerValueExtractor>> explicitExtractorClasses;

    public static ContainerValueExtractorPath defaultExtractors() {
        return DEFAULT;
    }

    public static ContainerValueExtractorPath noExtractors() {
        return NONE;
    }

    public static ContainerValueExtractorPath explicitExtractor(Class<? extends ContainerValueExtractor> extractorClass) {
        return new ContainerValueExtractorPath(false, Collections.singletonList(extractorClass));
    }

    public static ContainerValueExtractorPath explicitExtractors(List<? extends Class<? extends ContainerValueExtractor>> extractorClasses) {
        if (extractorClasses.isEmpty()) {
            return ContainerValueExtractorPath.noExtractors();
        }
        return new ContainerValueExtractorPath(false, Collections.unmodifiableList(new ArrayList<Class<? extends ContainerValueExtractor>>(extractorClasses)));
    }

    private ContainerValueExtractorPath(boolean applyDefaultExtractors, List<? extends Class<? extends ContainerValueExtractor>> explicitExtractorClasses) {
        this.applyDefaultExtractors = applyDefaultExtractors;
        this.explicitExtractorClasses = explicitExtractorClasses;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ContainerValueExtractorPath)) {
            return false;
        }
        ContainerValueExtractorPath other = (ContainerValueExtractorPath)obj;
        return this.applyDefaultExtractors == other.applyDefaultExtractors && Objects.equals(this.explicitExtractorClasses, other.explicitExtractorClasses);
    }

    public int hashCode() {
        return Objects.hash(this.applyDefaultExtractors, this.explicitExtractorClasses);
    }

    public String toString() {
        if (this.isDefault()) {
            return "<default value extractors>";
        }
        if (this.explicitExtractorClasses.isEmpty()) {
            return "<no value extractors>";
        }
        StringJoiner joiner = new StringJoiner(", ", "<", ">");
        for (Class<? extends ContainerValueExtractor> clazz : this.explicitExtractorClasses) {
            joiner.add(clazz.getName());
        }
        return joiner.toString();
    }

    public boolean isDefault() {
        return this.applyDefaultExtractors;
    }

    public boolean isEmpty() {
        return !this.isDefault() && this.explicitExtractorClasses.isEmpty();
    }

    public List<? extends Class<? extends ContainerValueExtractor>> getExplicitExtractorClasses() {
        return this.explicitExtractorClasses;
    }
}

